/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jgss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class GSSCallbackHandler
implements CallbackHandler {
    String username = null;
    String password = null;

    public GSSCallbackHandler(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public GSSCallbackHandler() {
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback;
            if (callbackArray[i] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[i];
                switch (((TextOutputCallback)callback).getMessageType()) {
                    case 0: {
                        System.out.println(((TextOutputCallback)callback).getMessage());
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + ((TextOutputCallback)callback).getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + ((TextOutputCallback)callback).getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + ((TextOutputCallback)callback).getMessageType());
                    }
                }
                continue;
            }
            if (callbackArray[i] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i];
                if (this.username != null && this.username.length() > 0) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                System.err.print(((NameCallback)callback).getPrompt());
                System.err.flush();
                ((NameCallback)callback).setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[i];
                if (this.password != null && this.password.length() > 0) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                ((PasswordCallback)callback).setPassword(this.readPassword(System.in, ((PasswordCallback)callback).getPrompt()));
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
        }
    }

    private char[] readPassword(InputStream inputStream, String string) throws IOException {
        Object object;
        MaskingThread maskingThread = new MaskingThread(string);
        if (!System.getProperty("os.name").equals("OpenVMS")) {
            object = new Thread(maskingThread);
            object.start();
        }
        char[] cArray = object = new char[128];
        int n = cArray.length;
        int n2 = 0;
        block4: while (true) {
            int n3 = inputStream.read();
            switch (n3) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                }
                default: {
                    if (--n < 0) {
                        cArray = new char[n2 + 128];
                        n = cArray.length - n2 - 1;
                        System.arraycopy(object, 0, cArray, 0, n2);
                        Arrays.fill(object, ' ');
                        object = cArray;
                    }
                    cArray[n2++] = (char)n3;
                    continue block4;
                }
            }
            break;
        }
        maskingThread.stopMasking();
        if (n2 == 0) {
            return null;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        Arrays.fill(cArray, ' ');
        return cArray2;
    }

    class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private String prompt;

        public MaskingThread(String string) {
            int n;
            if (!string.endsWith(" ")) {
                string = string + " ";
            }
            System.out.print(string);
            while ((n = string.indexOf(10)) >= 0) {
                string = string.substring(n + 1);
            }
            this.prompt = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int n = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = false;
                while (!this.stop) {
                    System.out.print("\r" + this.prompt + " \b");
                    System.out.flush();
                    try {
                        Thread.currentThread();
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(n);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(n);
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

