/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.SysResultSet;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheQuery;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.Database;
import com.intersys.objects.ResultSetColumn;
import com.intersys.objects.StatusCode;
import com.intersys.objects.StatusCodeHolder;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSet
extends SysResultSet {
    protected CacheQuery m_cachequery;
    protected java.sql.ResultSet m_resultset;
    protected Dataholder[] m_args = new Dataholder[0];

    public ResultSet(Database database, String string, String string2) throws CacheException {
        super(database, string + ":" + string2);
        this.m_cachequery = new CacheQuery(database, string, string2);
    }

    public ResultSet(CacheObject cacheObject) throws CacheException {
        super(cacheObject);
    }

    public ResultSet(Database database, String string, int n) throws CacheException {
        super(database);
        this.m_cachequery = new CacheQuery(database, string);
    }

    public int getColumnCount() throws CacheException {
        if (this.m_cachequery == null) {
            return super._getColumnCount();
        }
        try {
            return this.m_cachequery.getMetaData().getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public ResultSetColumn[] getColumns() throws CacheException {
        try {
            ResultSetMetaData resultSetMetaData = this.m_cachequery.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            ResultSetColumn[] resultSetColumnArray = new ResultSetColumn[n];
            for (int i = 1; i <= n; ++i) {
                resultSetColumnArray[i - 1] = new ResultSetColumn(i, resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnLabel(i), resultSetMetaData.getColumnTypeName(i));
            }
            return resultSetColumnArray;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public void finalize() throws CacheException {
        this.closeSQL();
    }

    public void clearParameters() {
        this.m_args = null;
    }

    public void setBoolean(int n, boolean bl) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(new Boolean(bl));
    }

    public void setInt(int n, int n2) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(new Integer(n2));
    }

    public void setLong(int n, long l) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(new Long(l));
    }

    public void setDate(int n, Date date) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(date);
    }

    public void setTime(int n, Time time) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(timestamp);
    }

    public void setSysList(int n, Object object) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(384, object);
    }

    public void setString(int n, String string) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(string);
    }

    public void setDouble(int n, double d) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(new Double(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws CacheException {
        if (n > this.m_args.length) {
            Dataholder[] dataholderArray = new Dataholder[n];
            System.arraycopy(this.m_args, 0, dataholderArray, 0, this.m_args.length);
            this.m_args = dataholderArray;
        }
        this.m_args[n - 1] = new Dataholder(bigDecimal);
    }

    public void execute() throws CacheException {
        if (this.m_cachequery == null) {
            super._execute(this.m_args);
            return;
        }
        this.m_resultset = this.m_cachequery.execute((Object[])this.m_args);
    }

    public java.sql.ResultSet asJDBCResultSet() throws CacheException {
        if (this.m_resultset != null) {
            return this.m_resultset;
        }
        SysDatabase sysDatabase = (SysDatabase)this.getDatabase();
        return sysDatabase.getCacheResultSet((String)this.getZRef());
    }

    public boolean next() throws CacheException {
        if (this.m_cachequery == null) {
            StatusCodeHolder statusCodeHolder = new StatusCodeHolder(null);
            Integer n = super._next(statusCodeHolder);
            this.getDatabase().parseStatus((StatusCode)statusCodeHolder.getValue());
            return n != 0;
        }
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.next();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public boolean getBoolean(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getBoolean(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public boolean getBoolean(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getBoolean(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public int getInt(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getInt(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public int getInt(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getInt(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public long getLong(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getLong(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public long getLong(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getLong(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Date getDate(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getDate(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Date getDate(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getDate(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Time getTime(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getTime(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Time getTime(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getTime(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Timestamp getTimestamp(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Timestamp getTimestamp(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Object getSysList(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            byte[] byArray = this.m_resultset.getBytes(n);
            ConnectionInfo connectionInfo = ((SysDatabase)this.getDatabase()).getConnectionInfo();
            return SysListProxy.createSysList(byArray, connectionInfo);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public Object getSysList(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            byte[] byArray = this.m_resultset.getBytes(string);
            ConnectionInfo connectionInfo = ((SysDatabase)this.getDatabase()).getConnectionInfo();
            return SysListProxy.createSysList(byArray, connectionInfo);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public String getString(int n) throws CacheException {
        if (this.m_cachequery == null) {
            return super._getData(new Integer(n));
        }
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getString(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public String getString(String string) throws CacheException {
        if (this.m_cachequery == null) {
            return super._getDataByName(string);
        }
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getString(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public double getDouble(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getDouble(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public double getDouble(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getDouble(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws CacheException {
        try {
            if (this.m_resultset == null) {
                throw new CacheServerException("ResultSetNotOpened");
            }
            return this.m_resultset.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public void closeSQL() throws CacheException {
        this.close();
        this.m_cachequery = null;
    }

    public final void close() throws CacheException {
        if (this.m_resultset != null) {
            try {
                this.m_resultset.close();
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException);
            }
        }
        super.close();
    }

    public boolean isOpen() {
        return this.m_resultset != null;
    }
}

