/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.serial.SerialMetadataFactory;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class CacheMetadataFactory
extends SerialMetadataFactory {
    CallableStatement mStatement;
    private static final String STATEMENT = " ? = %Library.CPPStoredProc_getSerialStateFull ( ?, ? )";

    public CacheMetadataFactory(SysDatabase sysDatabase, Connection connection) throws SQLException {
        super(sysDatabase);
        this.mStatement = connection.prepareCall(STATEMENT);
        this.init();
    }

    public CacheMetadataFactory(SysDatabase sysDatabase, Database database) throws CacheException, SQLException {
        super(sysDatabase);
        this.mStatement = database.prepareCall(STATEMENT);
        this.init();
    }

    private void init() throws SQLException {
        this.mStatement.registerOutParameter(1, -2);
        this.mStatement.setBoolean(3, true);
    }

    public byte[] getSerialInfo(String string) throws SQLException {
        this.mStatement.setString(2, string);
        this.mStatement.execute();
        byte[] byArray = this.mStatement.getBytes(1);
        return byArray;
    }

    public byte[] getStaticDictionary() throws SQLException {
        throw new UnsupportedOperationException("Method getStaticDictionary() must never tbe called here.");
    }

    public void close() {
        try {
            this.mStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getCacheClassForJavaClassSQL() {
        return "select name from %Dictionary.ClassDefinition where (clientname = ?) OR (clientname IS NULL and name = ?)";
    }
}

