/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.quick.ChidTableClass;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickCacheClassNew;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.cache.quick.ThirdPartyDBAdapter;
import com.intersys.cache.serial.SerialObjectFactory;
import com.intersys.cache.serial.ThirdPartyDBMetadataFactory;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Persistent;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.SQLColumn;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ThirdPartyDatabase
extends LightDatabase {
    ThirdPartyDBMetadataFactory mMDF;
    private ConnectionInfo mConnectionInfo = null;

    public ThirdPartyDatabase(Connection connection) throws CacheException {
        super(connection);
    }

    protected void onInitDatabase(Connection connection) throws CacheException {
        try {
            this.mAdapter = new ThirdPartyDBAdapter(this, connection);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.mInfo.cacheSystemVersion = databaseMetaData.getDatabaseProductName();
            this.mInfo.cacheObjectVersion = databaseMetaData.getDatabaseProductVersion();
            this.mInfo.protocolClientVersion = this.mInfo.protocolServerVersion = databaseMetaData.getDriverVersion();
            this.mInfo.connectionInfo = databaseMetaData.getURL();
            this.mInfo.namespace = connection.getCatalog();
            SerialObjectFactory serialObjectFactory = new SerialObjectFactory(this.mInfo.connectionInfo);
            this.mMDF = new ThirdPartyDBMetadataFactory(serialObjectFactory, this.myConnection());
            serialObjectFactory.setMetadataFactory(this.mMDF);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException);
        }
    }

    protected TableBasedClass createQuickCacheClass(String string, boolean bl) throws CacheException {
        JavaClassDef javaClassDef = this.mMDF.getJavaClassDef(string);
        return new QuickCacheClassNew(this, javaClassDef);
    }

    public String getBaseTable(String string) throws SQLException {
        String string2 = this.mMDF.getBaseTable(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public String getSequence(String string) throws SQLException {
        String string2 = this.mMDF.getSequenceName(string);
        return string2;
    }

    public ConnectionInfo getConnectionInfo() {
        if (this.mConnectionInfo == null) {
            this.mConnectionInfo = new ConnectionInfo();
        }
        return this.mConnectionInfo;
    }

    public String getCacheClassForJavaClassSQL() {
        return ThirdPartyDBMetadataFactory.getCacheClassForJavaClassSQL();
    }

    protected Iterator getResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) throws CacheException {
        return new AnyResultSetIterator(resultSet, tableBasedClass, n);
    }

    public void createObjects(String string, Collection collection) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)this.getCacheClass(string);
        String string2 = tableBasedClass.getSchemaName();
        String string3 = tableBasedClass.getSQLTableName();
        ArrayList<Persistent> arrayList = new ArrayList<Persistent>();
        int n = 0;
        for (Persistent persistent : collection) {
            Object object;
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)persistent.getProxy();
            int n2 = quickPersistentObject.save(object = SysListProxy.createSysList(this.mConnectionInfo), true, false);
            if (n2 == 2) {
                arrayList.add(persistent);
            }
            ((ThirdPartyDBAdapter)this.myAdapter()).addToCreateBatch(string2, string3, object, tableBasedClass);
            if (Logger.getDebugCache()) {
                Logger.out.println(n + ": values: " + object.toString());
            }
            ++n;
        }
        ((ThirdPartyDBAdapter)this.myAdapter()).executeBatchCreate(string2, string3);
    }

    public int transactionLevel() throws CacheException {
        try {
            boolean bl = this.myConnection().getAutoCommit();
            if (bl) {
                return 0;
            }
            return 1;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine transaction level.");
        }
    }

    protected void onClose() {
    }

    protected boolean serverSupportsBulk() {
        return false;
    }

    protected TableBasedClass createQuickCacheClass(ColumnBasedField columnBasedField) throws CacheException {
        QuickCacheClassNew quickCacheClassNew = (QuickCacheClassNew)this.getCacheClass(columnBasedField.getElementTypeName());
        ChidTableClass chidTableClass = new ChidTableClass((LightDatabase)this, quickCacheClassNew, columnBasedField.getChildTableMetadata(), columnBasedField.getCollectionType());
        this.mClassMap.put(columnBasedField.getChildTableName(), chidTableClass);
        return chidTableClass;
    }

    protected String getColumnSQL(TableBasedClass tableBasedClass) throws CacheException {
        String string = super.getColumnSQL(tableBasedClass);
        string = string.replaceAll("%Version", "_Version");
        return string;
    }

    protected String adjustSQL(TableBasedClass tableBasedClass, String string) throws CacheException {
        String string2 = tableBasedClass.getSQLTableMetadata().getRowIdColumn().getName();
        string2 = tableBasedClass.getFullSQLTableName() + "." + string2;
        String string3 = tableBasedClass.getFullSQLTableName() + ".%ID";
        string = string.replaceAll(string3, string2);
        return string;
    }

    protected boolean commaSeparatedCollectionsInRS() {
        return false;
    }

    public TableBasedClass createQuickCacheClassByTable(String string, boolean bl) throws CacheException {
        JavaClassDef javaClassDef = this.mMDF.getJavaClassDefByTable(string);
        return new QuickCacheClassNew(this, javaClassDef);
    }

    public CacheField createCacheField(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        throw new UnsupportedOperationException("Method createCacheField() is not implemented in class com.intersys.cache.quick.ThirdPartyDatabase");
    }

    public int getReflectionVersion() throws CacheException {
        try {
            int n = this.mMDF.getMDVersion();
            return n;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine metadata version");
        }
    }

    public ReadOnlyDatabase getReadOnlyDatabase() throws CacheException {
        throw new UnsupportedOperationException("Method getReadOnlyDatabase() is not implemented in class com.intersys.cache.quick.ThirdPartyDatabase");
    }

    private class AnyResultSetIterator
    extends LightDatabase.ResultSetIterator {
        private SQLColumn[] mColumns;

        public AnyResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) throws CacheException {
            super(resultSet, tableBasedClass, n);
            this.mColumns = tableBasedClass.getSQLTableMetadata().getColumns();
        }

        protected Object getWire() throws SQLException {
            return ((ThirdPartyDBAdapter)ThirdPartyDatabase.this.myAdapter()).getRow(this.mRS, this.mColumns);
        }
    }
}

