/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.AbstractElementInfoImpl;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.TypeModifierHelper;
import java.sql.Date;

public class ColumnOnlyField
extends AbstractElementInfoImpl
implements ColumnBasedField {
    SQLColumn mColumn;
    private int mColumnIdxForGet = -1;
    private int mColumnIdxForSet = -1;
    private SysDatabase mDB;
    private int mModifier = 0;

    public ColumnOnlyField(SysDatabase sysDatabase, SQLColumn sQLColumn, int n) {
        this.mColumn = sQLColumn;
        this.mDB = sysDatabase;
        this.init(n);
    }

    private void init(int n) {
        this.mColumnIdxForGet = this.mColumn.getNumber() - n + 1;
        this.mColumnIdxForSet = this.mColumnIdxForGet - 1;
        if (this.mColumn.isElementDatatype()) {
            this.addModifier(16);
        }
    }

    protected final void addModifier(int n) {
        this.mModifier |= n;
    }

    public ColumnBasedField getChildField(String string, int n, int n2) {
        return null;
    }

    public int getColumnIndexForGet() {
        return this.mColumnIdxForGet;
    }

    public int getColumnIndexForSet() {
        return this.mColumnIdxForSet;
    }

    public String columnNameForEmbProp(String string) throws CacheException {
        return null;
    }

    public boolean isEmbeddedSetUp() {
        return false;
    }

    public boolean isEmbedded() {
        return this.mColumn.isForEmbeddedObject();
    }

    public int getSerialStorageIndex() {
        return -1;
    }

    public int getTypeModifiers() {
        return this.mColumn.getTypeModifiers();
    }

    public String getName() {
        return this.mColumn.getFieldName();
    }

    public String getDefaultValueString() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public CacheClass getType() throws CacheException {
        if (this.mDB == null) {
            return null;
        }
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return this.mDB.getCacheClass(string);
    }

    public String getTypeName() {
        return this.mColumn.getTypeName();
    }

    public String getElementTypeName() {
        return null;
    }

    public String getJavaTypeName() {
        CacheClass cacheClass = null;
        try {
            cacheClass = this.getType();
            if (cacheClass != null) {
                return cacheClass.getJavaClassName();
            }
        }
        catch (CacheException cacheException) {
            return null;
        }
        return null;
    }

    public int getModifiers() {
        return this.mModifier;
    }

    public String getJavaName() {
        return this.getName();
    }

    public int getClientTypeId() {
        return this.mColumn.getDataTypeColumn();
    }

    public boolean isLiteral(boolean bl) {
        int n = this.getClientTypeId();
        return TypeModifierHelper.isPrimitive(n, bl);
    }

    public String getAccessorName() {
        return null;
    }

    public int getJDBCType() {
        return this.mColumn.getJDBCType();
    }

    public String getRealClass() {
        throw new UnsupportedOperationException("Method getRealClass() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    public Object get(Object object) throws CacheException {
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not get field value on object of type " + object.getClass().getName());
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((ObjectHandle)object).getProxy();
        boolean bl = this.isLiteral();
        Dataholder dataholder = quickPersistentObject.getProperty(this);
        if (bl) {
            return dataholder.getObject(this.getJavaTypeName());
        }
        CacheObject cacheObject = dataholder.getCacheObject();
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.newJavaInstance(true);
    }

    public Object get(int n) throws CacheException {
        throw new UnsupportedOperationException("Method get(int) is not supported in Light mode.");
    }

    public void set(int n, Object object) throws CacheException {
        throw new UnsupportedOperationException("Method set(int) is not supported in Light mode.");
    }

    public void set(Object object, Object object2) throws CacheException {
        Dataholder dataholder = null;
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not set field value on object of type " + object.getClass().getName());
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((ObjectHandle)object).getProxy();
        if (!this.isLiteral() && object2 instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object2;
            dataholder = new Dataholder(1026, objectHandle.getProxy());
        } else if (Date.class.getName().endsWith(this.getJavaTypeName())) {
            dataholder = Dataholder.create(object2);
            dataholder = new Dataholder(64, dataholder.getDate());
        } else {
            dataholder = Dataholder.create(object2);
        }
        quickPersistentObject.setProperty(this, dataholder, true, true);
    }

    public int getII() {
        throw new UnsupportedOperationException("Method getII() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    public int getJJ() {
        throw new UnsupportedOperationException("Method getJJ() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    public int getKK() {
        throw new UnsupportedOperationException("Method getKK() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    public boolean isChildTable() {
        return false;
    }

    public String getChildTableName() {
        return null;
    }

    public SQLColumn getSQLColumn() {
        return this.mColumn;
    }

    public String getInverseFieldName() {
        return null;
    }

    public boolean isSerial() throws CacheException {
        return this.isElementSerial();
    }

    public String[] getDisplayList() {
        return null;
    }

    public String[] getValueList() {
        return null;
    }

    public boolean isCalculated() {
        return this.isSQLComputed();
    }

    public boolean isSQLComputed() {
        return !this.mColumn.isUpdateable();
    }

    public boolean hasGet() {
        return true;
    }

    public boolean hasSet() {
        return this.mColumn.isUpdateable();
    }

    public boolean hasGetAsMethod() {
        return false;
    }

    public boolean hasSetAsMethod() {
        return false;
    }

    public boolean definedGet() {
        return false;
    }

    public boolean definedSet() {
        return false;
    }

    public String getGetAccessorName() {
        return null;
    }

    public String getDeclaredType() {
        throw new UnsupportedOperationException("Method getDeclaredType() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    public String getGetter() {
        throw new UnsupportedOperationException("Method getGetter() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }

    public boolean isTransient() {
        throw new UnsupportedOperationException("Method isTransient() is not implemented in class class com.intersys.cache.quick.ColumnOnlyField");
    }

    public boolean isVersionField() throws CacheException {
        return false;
    }

    public TableMetadata getChildTableMetadata() {
        return null;
    }

    public CacheClass getDeclaringCacheClass() throws CacheException {
        return this.mColumn.getContainingClass();
    }

    public boolean isRequired() throws CacheException {
        throw new UnsupportedOperationException("Method isRequired() is not implemented in class com.intersys.cache.quick.ColumnOnlyField");
    }
}

