/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.InvalidClassException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FieldNameIterator
implements Iterator {
    private final Object mSysList;
    private boolean hasElementTypeField;

    FieldNameIterator(byte[] byArray, Database database) throws InvalidClassException, CacheException {
        this.hasElementTypeField = ((SysDatabase)database).getReflectionVersion() >= 2;
        try {
            this.mSysList = SysListProxy.createSysList(byArray, false, new ConnectionInfo());
            Object object = SysListProxy.getWrappedItem(this.mSysList);
            Dataholder dataholder = new Dataholder(4096, object);
            try {
                database.parseStatus(dataholder);
            }
            catch (CacheException cacheException) {
                String string = cacheException.getMessage();
                int n = cacheException.getCode();
                throw new InvalidClassException(database, "", "Failed to get fields of class. Error message: " + string, n, cacheException);
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            int n = sQLException.getErrorCode();
            throw new InvalidClassException(database, "", "Failed to get fields of class. Error message: " + string, n, sQLException);
        }
    }

    public boolean hasNext() {
        return !SysListProxy.atEnd(this.mSysList);
    }

    public Object next() {
        if (SysListProxy.atEnd(this.mSysList)) {
            throw new NoSuchElementException();
        }
        int n = this.hasElementTypeField ? 4 : 3;
        int n2 = 3;
        try {
            SysListProxy.skip(this.mSysList, n);
            String string = SysListProxy.getString(this.mSysList);
            SysListProxy.skip(this.mSysList, n2);
            return string;
        }
        catch (SQLException sQLException) {
            throw new NoSuchElementException(sQLException.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

