/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.CacheObject;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.CacheArgumentIntrospector;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.CacheFieldIntrospector;
import com.intersys.cache.metadata.CacheMethodIntrospector;
import com.intersys.cache.metadata.CacheQueryIntrospector;
import com.intersys.cache.metadata.ColumnIntrospector;
import com.intersys.cache.metadata.ProtoMetadataFactory;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Compiler.LG.JavaColumnDef;
import com.intersys.classes.Compiler.LG.JavaMethodDef;
import com.intersys.classes.Compiler.LG.JavaMtdArgDef;
import com.intersys.classes.Compiler.LG.JavaPropDef;
import com.intersys.classes.Compiler.LG.MetaQueryDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.SQLColumn;

public class CacheClassIntrospector
extends CacheClassMetadataImpl
implements CacheClass {
    private SysDatabase mDB;
    private boolean mKeepSerial = false;
    private ProtoMetadataFactory mMPF = null;

    public CacheClassIntrospector(Database database, String string, String string2, boolean bl) throws CacheException {
        super(((SysDatabase)database).getReadOnlyDatabase(), string, string2, bl, true, false);
        this.mKeepSerial = bl;
        this.init(database);
    }

    public CacheClassIntrospector(Database database, String string, ProtoMetadataFactory protoMetadataFactory) throws CacheException {
        super(protoMetadataFactory.getJavaClassDef(string));
        this.mKeepSerial = false;
        this.mMPF = protoMetadataFactory;
        this.init(database);
    }

    public CacheClassIntrospector(Database database, String string, String string2) throws CacheException {
        this(database, string, string2, false);
    }

    public CacheClassIntrospector(Database database, String string, boolean bl) throws CacheException {
        super(((SysDatabase)database).getReadOnlyDatabase(), string, "", bl, true, false);
        this.mKeepSerial = bl;
        this.init(database);
    }

    public CacheClassIntrospector(Database database, String string) throws CacheException {
        this(database, string, false);
    }

    public CacheClassIntrospector(Database database, JavaClassDef javaClassDef) throws CacheException {
        super(javaClassDef);
        this.init(database);
    }

    private final void init(Database database) throws CacheException {
        this.mDB = (SysDatabase)database;
        this.mDB.addClass(this, this.getJavaClassName());
    }

    public void close() {
    }

    public Class getJavaClass() throws CacheException {
        try {
            return Class.forName(this.getJavaClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheException(classNotFoundException, "Java class " + this.getJavaClassName() + " for Cache class " + this.getName() + " was not found");
        }
    }

    public SysDatabase getDatabase() {
        return this.mDB;
    }

    public CacheClass createClass(JavaClassDef javaClassDef) throws CacheException {
        CacheClassIntrospector cacheClassIntrospector = new CacheClassIntrospector((Database)this.mDB, javaClassDef);
        return cacheClassIntrospector;
    }

    public CacheClass createClass(String string) throws CacheException {
        CacheClassIntrospector cacheClassIntrospector = this.mMPF == null ? new CacheClassIntrospector((Database)this.mDB, string, this.getFlags(), this.mKeepSerial) : new CacheClassIntrospector((Database)this.mDB, string, this.mMPF);
        return cacheClassIntrospector;
    }

    public CacheField createField(JavaPropDef javaPropDef) throws CacheException {
        return new CacheFieldIntrospector((CacheClass)this, javaPropDef);
    }

    public CacheMethod createMethod(CacheClassMetadata cacheClassMetadata, JavaMethodDef javaMethodDef) throws CacheException {
        return new CacheMethodIntrospector(cacheClassMetadata, this, javaMethodDef);
    }

    public CacheArgument createArgument(JavaMtdArgDef javaMtdArgDef) throws CacheException {
        return new CacheArgumentIntrospector(this, javaMtdArgDef);
    }

    public CacheQueryDefinition createQueryDef(MetaQueryDef metaQueryDef) throws CacheException {
        return new CacheQueryIntrospector(this, metaQueryDef);
    }

    protected SQLColumn createColumn(JavaColumnDef javaColumnDef) throws CacheException {
        return new ColumnIntrospector(this.getSQLTableMetadata(), this, null, javaColumnDef);
    }

    public Object newInstance(String string) throws CacheException {
        return null;
    }

    public Object newInstance(CacheObject cacheObject) throws CacheException {
        return null;
    }

    public Object newInstance(CacheObject cacheObject, boolean bl) throws CacheException {
        return null;
    }

    public Object createClientObject() throws CacheException {
        throw new UnsupportedOperationException("Method createClientObject() is not implemented in class com.intersys.cache.metadata.CacheClassIntrospector");
    }

    public Object openObject(Id id) throws CacheException {
        return null;
    }

    public Object openObject(Oid oid) throws CacheException {
        return null;
    }

    public void deleteObject(Id id) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.metadata.CacheClassIntrospector");
    }

    public CandidateKey createKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() is not implemented in class com.intersys.cache.metadata.CacheClassIntrospector");
    }

    public CandidateKey createKey(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() is not implemented in class com.intersys.cache.metadata.CacheClassIntrospector");
    }

    public CandidateKey createBestCandidateKey() throws CacheException {
        return null;
    }

    public CandidateKey createPrimaryKey() throws CacheException {
        return null;
    }

    public CandidateKey createPrimaryKey(String string) throws CacheException {
        return null;
    }

    public Object openByKey(CandidateKey candidateKey) throws CacheException {
        return null;
    }

    public Object openByPrimaryKey(String string) throws CacheException {
        return null;
    }

    public boolean deleteObjectByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByKey() is not implemented in class com.intersys.cache.metadata.CacheClassIntrospector");
    }

    public boolean deleteObjectByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByPrimaryKey() is not implemented in class com.intersys.cache.metadata.CacheClassIntrospector");
    }

    public final boolean isVerified() {
        return true;
    }

    public void verifyClass() {
    }
}

