/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.UniqueIndexMetadataImpl;
import com.intersys.classes.Compiler.LG.JavaConstraintDef;
import com.intersys.classes.Compiler.LG.JavaTableDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.UniqueIndexMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTable
implements TableMetadata {
    protected SQLColumn[] mColumns;
    protected Map mColumnsByName = null;
    protected int mXClassNameColumnNumber = -1;
    protected int mRowIDNumber = -1;
    protected String mRowIDType;
    protected String mCacheClassName;
    protected String mTableName;
    protected String mSchemaName;
    protected int mMaxColumn;
    protected int mMinColumn;
    protected CacheClass mCacheClass;
    protected int[] mColumnLookupArray;
    protected UniqueIndexMetadata mPrimaryKey;
    protected UniqueIndexMetadata[] mUniqueIndicies;
    private JavaTableDef mJavaTableDef;

    protected AbstractTable(JavaTableDef javaTableDef) {
        this.mJavaTableDef = javaTableDef;
    }

    protected void checkColumns() throws CacheException {
        SQLColumn sQLColumn;
        int n;
        if (this.mColumns.length == 0) {
            throw new SystemError("Table " + this.getFullName() + " contains no columns.");
        }
        this.mMaxColumn = 0;
        this.mMinColumn = Integer.MAX_VALUE;
        for (n = 0; n < this.mColumns.length; ++n) {
            sQLColumn = this.mColumns[n];
            if (sQLColumn.isXClassName()) {
                this.mXClassNameColumnNumber = sQLColumn.getNumber();
            }
            if (sQLColumn.isRowIdColumn()) {
                this.mRowIDNumber = sQLColumn.getNumber();
            }
            if (sQLColumn.getNumber() > this.mMaxColumn) {
                this.mMaxColumn = sQLColumn.getNumber();
            }
            if (sQLColumn.getNumber() >= this.mMinColumn) continue;
            this.mMinColumn = sQLColumn.getNumber();
        }
        this.mColumnLookupArray = new int[this.mMaxColumn + 1];
        n = 0;
        while (n < this.mColumns.length) {
            sQLColumn = this.mColumns[n];
            this.mColumnLookupArray[sQLColumn.getNumber()] = n++;
        }
    }

    public abstract String getRowIdType() throws CacheException;

    private void setIndicies() throws CacheException {
        if (this.mJavaTableDef != null) {
            CacheIndexInfo[] cacheIndexInfoArray;
            int n;
            if (this.mJavaTableDef.getHasPrimaryKey()) {
                boolean bl = false;
                CacheIndexInfo[] cacheIndexInfoArray2 = this.mCacheClass.getIndexInfo();
                for (n = 0; n < cacheIndexInfoArray2.length; ++n) {
                    CacheIndexInfo cacheIndexInfo = cacheIndexInfoArray2[n];
                    if (!cacheIndexInfo.isPrimaryKey()) continue;
                    this.mPrimaryKey = new UniqueIndexMetadataImpl((TableMetadata)this, cacheIndexInfo, true);
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new SystemError("expecting primary key in class " + this.mCacheClass.getName() + ", table " + this.getName());
                }
            } else {
                this.mPrimaryKey = null;
            }
            if ((cacheIndexInfoArray = this.mCacheClass.getIndexInfo()) != null && cacheIndexInfoArray.length != 0) {
                int n2 = 0;
                for (n = 0; n < cacheIndexInfoArray.length; ++n) {
                    if (!cacheIndexInfoArray[n].isUnique() && !cacheIndexInfoArray[n].isPrimaryKey()) continue;
                    ++n2;
                }
                this.mUniqueIndicies = new UniqueIndexMetadataImpl[n2];
                n = 0;
                if (this.mPrimaryKey != null) {
                    this.mUniqueIndicies[n++] = this.mPrimaryKey;
                }
                for (int i = 0; i < cacheIndexInfoArray.length; ++i) {
                    if (!cacheIndexInfoArray[i].isUnique() || cacheIndexInfoArray[i].isPrimaryKey()) continue;
                    this.mUniqueIndicies[n++] = new UniqueIndexMetadataImpl((TableMetadata)this, cacheIndexInfoArray[i], false);
                }
            } else {
                this.setNullIndices();
            }
        } else {
            this.setNullIndices();
        }
    }

    private void setOldIndicies() throws CacheException {
        if (this.mJavaTableDef != null) {
            List list;
            int n = 0;
            if (this.mJavaTableDef.getHasPrimaryKey()) {
                ++n;
                this.mPrimaryKey = new UniqueIndexMetadataImpl((TableMetadata)this, this.mJavaTableDef.getPrimaryKey(), true);
            }
            if ((list = this.mJavaTableDef.getConstraints()) != null) {
                int n2 = n;
                this.mUniqueIndicies = new UniqueIndexMetadataImpl[n += list.size()];
                int n3 = 0;
                if (this.mPrimaryKey != null) {
                    this.mUniqueIndicies[n3++] = this.mPrimaryKey;
                }
                while (n3 < n) {
                    this.mUniqueIndicies[n3] = new UniqueIndexMetadataImpl((TableMetadata)this, (JavaConstraintDef)list.get(n3 - n2), false);
                    ++n3;
                }
            } else {
                this.mUniqueIndicies = new UniqueIndexMetadata[0];
            }
        } else {
            this.mPrimaryKey = null;
            this.mUniqueIndicies = new UniqueIndexMetadata[0];
        }
    }

    public SQLColumn[] getColumns() throws CacheException {
        SQLColumn[] sQLColumnArray = new SQLColumn[this.mColumns.length];
        System.arraycopy(this.mColumns, 0, sQLColumnArray, 0, this.mColumns.length);
        return sQLColumnArray;
    }

    public SQLColumn getColumn(int n) throws CacheException {
        int n2 = n;
        if (n2 <= this.mMaxColumn && n2 >= 0) {
            return this.mColumns[this.mColumnLookupArray[n2]];
        }
        return null;
    }

    public SQLColumn getColumn(String string) throws CacheException {
        if (this.mColumnsByName == null) {
            this.mColumnsByName = new HashMap(this.mColumns.length);
            for (int i = 0; i < this.mColumns.length; ++i) {
                this.mColumnsByName.put(this.mColumns[i].getName(), this.mColumns[i]);
            }
        }
        return (SQLColumn)this.mColumnsByName.get(string);
    }

    public SQLColumn getRowIdColumn() throws CacheException {
        return this.getColumn(this.getRowIdColumnNumber());
    }

    public int getXClassNameColumnNumber() throws CacheException {
        return this.mXClassNameColumnNumber;
    }

    public String getCacheClassName() {
        return this.mCacheClassName;
    }

    public String getName() {
        return this.mTableName;
    }

    public int getRowIdColumnNumber() throws CacheException {
        return this.mRowIDNumber;
    }

    public String getSchemaName() {
        return this.mSchemaName;
    }

    public String getFullName() {
        return this.mSchemaName + "." + this.mTableName;
    }

    public int getMinColumnNumber() throws CacheException {
        return this.mMinColumn;
    }

    public int getMaxColumnNumber() throws CacheException {
        return this.mMaxColumn;
    }

    public CandidateKeyInfo getPrimaryKey() throws CacheException {
        if (this.mUniqueIndicies == null) {
            this.initIndices();
        }
        return this.mPrimaryKey;
    }

    public UniqueIndexMetadata[] getUniqueIndicies() throws CacheException {
        if (this.mUniqueIndicies == null) {
            this.initIndices();
        }
        return this.mUniqueIndicies;
    }

    protected void initIndices() throws CacheException {
        if (this.mUniqueIndicies != null) {
            return;
        }
        boolean bl = ((CacheClassMetadataImpl)this.mCacheClass).serverSupportsIndices();
        if (bl) {
            this.setIndicies();
        } else {
            this.setOldIndicies();
        }
    }

    public CandidateKeyInfo getCandidateKey(String string) throws CacheException {
        if (this.mUniqueIndicies == null) {
            this.initIndices();
        }
        for (int i = 0; i < this.mUniqueIndicies.length; ++i) {
            if (!this.mUniqueIndicies[i].getSQLName().equals(string)) continue;
            return this.mUniqueIndicies[i];
        }
        throw new CacheException("No candidate key with name " + string + " is defined in table " + this.getFullName());
    }

    protected void setNullIndices() {
        this.mPrimaryKey = null;
        this.mUniqueIndicies = new UniqueIndexMetadata[0];
    }
}

