/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jdbcutil;

import com.intersys.cache.jdbcutil.GeneralDBAdapter;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class RDBMSAdapter
implements GeneralDBAdapter {
    private static final int DEFAULT_NUMBER_OF_PROFILES = 2;
    public static int NUMBER_OF_PROFILES = -1;
    protected static long mElapsedTime = 0L;
    protected static long[] mElapsedTimeArray;
    protected static int[] mNumCallsArray;
    protected static boolean[] mProfileFlag;
    protected static int mNumCalls;
    protected final Connection mConnection;
    protected Statement mCountCommand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDBMSAdapter(Connection connection) throws CacheException {
        this.mConnection = connection;
        Class<RDBMSAdapter> clazz = RDBMSAdapter.class;
        synchronized (RDBMSAdapter.class) {
            if (mProfileFlag == null) {
                int n = RDBMSAdapter.determineNumberOfProfiles();
                mElapsedTimeArray = new long[n];
                mProfileFlag = new boolean[n];
                mNumCallsArray = new int[n];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static int determineNumberOfProfiles() throws CacheException {
        String string = System.getProperty("com.intersys.profile.segments");
        if (string == null) {
            if (NUMBER_OF_PROFILES < 0) {
                NUMBER_OF_PROFILES = 2;
            }
            return NUMBER_OF_PROFILES;
        }
        try {
            NUMBER_OF_PROFILES = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CacheException("Invalid number of profile segments specified in system properties: " + string);
        }
        return NUMBER_OF_PROFILES;
    }

    public static void setNumberOfProfiles(int n) {
        NUMBER_OF_PROFILES = n;
    }

    public static int getNumberOfProfiles() {
        try {
            RDBMSAdapter.determineNumberOfProfiles();
        }
        catch (CacheException cacheException) {
            return 2;
        }
        return NUMBER_OF_PROFILES;
    }

    private synchronized void initCountStatement() throws CacheServerException {
        if (this.mCountCommand != null) {
            return;
        }
        try {
            this.mCountCommand = this.mConnection.createStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, RDBMSAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    public synchronized int countElements(String string, String string2) throws CacheServerException {
        if (this.mCountCommand == null) {
            this.initCountStatement();
        }
        try {
            String string3 = "SELECT COUNT(*) FROM " + string + " WHERE " + string2;
            ResultSet resultSet = this.mCountCommand.executeQuery(string3);
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            throw new CacheServerException("Failed to count elements in " + string + " with condition " + string2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to count elements in " + string + " with condition " + string2);
        }
    }

    private static void printRowMetadata(ResultSet resultSet, int n) throws SQLException {
        for (int i = 1; i <= n; ++i) {
            System.out.print(i + ": " + resultSet.getObject(i) + "\t ");
        }
        System.out.println();
    }

    private static int printRSMetadata(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            System.out.print(i + ": " + resultSetMetaData.getColumnName(i) + "\t ");
        }
        System.out.println();
        return n;
    }

    protected synchronized void execute(CallableStatement callableStatement, String string) throws CacheServerException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, RDBMSAdapter.sqlErrorText("Failed to execute " + string, sQLException));
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
    }

    public static CallableStatement prepareCall(Connection connection, String string) throws CacheServerException {
        try {
            return connection.prepareCall(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, RDBMSAdapter.sqlErrorText("Failed to prepare call: " + string, sQLException));
        }
    }

    public static String sqlErrorText(String string, SQLException sQLException) {
        SQLException sQLException2 = sQLException.getNextException();
        String string2 = string + "\n[Message: <" + sQLException.getMessage() + "> Error code: <" + sQLException.getErrorCode() + "> SQL state: <" + sQLException.getSQLState() + ">]";
        if (sQLException2 == null) {
            return string2;
        }
        return RDBMSAdapter.sqlErrorText(string2, sQLException2);
    }

    public long getServerTime() {
        return mElapsedTime;
    }

    public int getNumberServerCalls() {
        return mNumCalls;
    }

    public long getServerTime(int n) {
        return mElapsedTimeArray[n];
    }

    public int getNumberServerCalls(int n) {
        return mNumCallsArray[n];
    }

    public void resetProfile(int n) {
        RDBMSAdapter.mElapsedTimeArray[n] = 0L;
        RDBMSAdapter.mNumCallsArray[n] = 0;
    }

    public void setProfileOn(int n) {
        RDBMSAdapter.mProfileFlag[n] = true;
    }

    public void setProfileOff(int n) {
        RDBMSAdapter.mProfileFlag[n] = false;
    }

    public void close(boolean bl) throws CacheServerException {
        if (bl) {
            try {
                this.mConnection.close();
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException, "Failed to close prepared JDBC Connection");
            }
        }
    }

    public ResultSet executeQuery(PreparedStatement preparedStatement) throws SQLException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        ResultSet resultSet = preparedStatement.executeQuery();
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return resultSet;
    }

    static {
        mNumCalls = 0;
    }
}

