/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    public String getConstraintType() {
        return "CHECK";
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.filter = tableFilter;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("ALTER TABLE ");
        stringBuilder.append(table.getSQL()).append(" ADD CONSTRAINT ").append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append(" CHECK").append(StringUtils.enclose(this.expr.getSQL())).append(" NOCHECK");
        return stringBuilder.toString();
    }

    private String getShortDescription() {
        return this.getName() + ": " + this.expr.getSQL();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) {
        if (row2 == null) {
            return;
        }
        this.filter.set(row2);
        if (Boolean.FALSE.equals(this.expr.getValue(session).getBoolean())) {
            throw DbException.get(23000, this.getShortDescription());
        }
    }

    public boolean usesIndex(Index index) {
        return false;
    }

    public void setIndexOwner(Index index) {
        DbException.throwInternalError();
    }

    public boolean containsColumn(Column column) {
        String string = column.getSQL();
        String string2 = this.getCreateSQL();
        return string2.indexOf(string) >= 0;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        String string = "SELECT 1 FROM " + this.filter.getTable().getSQL() + " WHERE NOT(" + this.expr.getSQL() + ")";
        ResultInterface resultInterface = session.prepare(string).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23000, this.getName());
        }
    }

    public Index getUniqueIndex() {
        return null;
    }

    public void rebuild() {
    }
}

