/*
 * Copyright 2019 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.widgets.core.client.editors.defaulteditor;

import java.util.Map;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.backend.vfs.PathFactory;

import static org.junit.Assert.assertEquals;

@RunWith(GwtMockitoTestRunner.class)
public class DefaultEditorFileUploadParametersTest {

    private DefaultEditorFileUpload upload;

    @Before
    public void setUp() throws Exception {
        upload = new DefaultEditorFileUpload() {
            @Override
            void initForm() {

            }
        };
    }

    @Test
    public void testPathParameterIsEncoded() {
        upload.setPath(new PathFactory.PathImpl("foo.txt", "default://foo & bar.txt"));
        upload.setIsUpdate(true);

        final Map<String, String> parameters = upload.getParameters();

        assertEquals(2, parameters.size());
        assertEquals("default%3A%2F%2Ffoo+%26+bar.txt", parameters.get("path"));
        assertEquals("true", parameters.get("update"));
    }
}