/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Implements
 * <a href="https://docs.optaplanner.org/latest/optaplanner-docs/html_single/#planningEntityDifficulty">
 * planning entity difficulty comparison
 * </a>
 * or
 * <a href="https://docs.optaplanner.org/latest/optaplanner-docs/html_single/#planningValueStrength">
 * planning variable strength comparison
 * </a>
 * to enable advanced
 * <a href="https://docs.optaplanner.org/latest/optaplanner-docs/html_single/#constructionHeuristics">
 * Construction Heuristic
 * </a>
 * algorithms or
 * <a href="https://docs.optaplanner.org/latest/optaplanner-docs/html_single/#sortedSelection">
 * sorted selection
 * </a>.
 */
package org.optaweb.vehiclerouting.plugin.planner.weight;
