/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.server.management.backend.storage;

import java.io.IOException;

import org.junit.After;
import org.junit.Before;
import org.kie.server.controller.impl.storage.ServerTemplateStorageTest;
import org.uberfire.mocks.FileSystemTestingUtils;

public class ServerTemplateVFSStorageTest extends ServerTemplateStorageTest {

    private FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    
    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        templateStorage = new ServerTemplateVFSStorage(fileSystemTestingUtils.getIoService(), fileSystemTestingUtils.getFileSystem());

        createServerTemplateWithContainer();
    }

    @After
    public void cleanup() {
        fileSystemTestingUtils.cleanup();
    }

}
