/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.ala.pipeline;

import java.util.Optional;
import java.util.function.BiFunction;

/*
 * BiFunctionConfigExecutor implementations will provide a result based on two inputs.
 *  notice that this interface extends the functional interface BiFunction.
 * @param <T> the type of the first argument to the function
 * @param <U> the type of the second argument to the function
 * @param <R> the type of the result of the function
 *  @see BiFunction
 */
public interface BiFunctionConfigExecutor<T, U, R> extends ConfigExecutor,
                                                           BiFunction<T, U, Optional<R>> {

}
