package com.redhat.installer.tests.installation.processpanel;

import com.izforge.izpack.rules.RulesEngine;
import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.installation.processpanel.TomcatAddDataSource;
import org.junit.Before;
import org.junit.Test;

import java.util.Hashtable;

import static com.redhat.installer.framework.stub.ConditionStubber.asFalse;
import static com.redhat.installer.framework.stub.ConditionStubber.asTrue;

public class TomcatAddDataSourceTest extends TomcatAddResourceTest {

    @Before
    public void setUp() throws Exception {
        super.setUp();
        idata.setRules(new RulesEngine(new Hashtable<>(), idata));
    }

    @Test
    public void shouldNotAddAdditionalParameters() throws Exception {
        idata.getRules().addCondition(asFalse("jdbc.driver.spliturl"));
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);

        boolean result = TomcatAddDataSource.run(handler, this.getTestArguments());

        assertCorrect(result, getDefaultCssQuery());
    }

    @Test
    public void shouldAddCustomProperties() throws Exception {
        unsetUrlSplitting();
        idata.getVariables().setProperty("jdbc.driver.customproperties", "prop1=val1;prop2=val2");
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);

        boolean result = TomcatAddDataSource.run(handler, this.getTestArguments());

        assertCorrect(result, getDefaultCssQuery() + "[prop1=val1][prop2=val2]");
    }

    @Test
    public void shouldNotAddUrlPropertiesWhenVendorIsNotTargeted() throws Exception {
        setUrlSplitting("vendor1", "jdbc:fake:conn:4321/definition");
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);

        boolean result = TomcatAddDataSource.run(handler, this.getTestArguments());

        assertCorrect(result, getDefaultCssQuery());
    }

    @Test
    public void shouldAddUrlPropertiesWhenVendorIsDB2() throws Exception {
        setUrlSplitting("ibmdb2", "jdbc:db2://server321:4321/4321bd");
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);

        boolean result = TomcatAddDataSource.run(handler, this.getTestArguments());

        assertCorrect(result, getDefaultCssQuery() + "[serverName=server321][databaseName=4321bd][portNumber=4321]");
    }

    @Test
    public void shouldAddUrlPropertiesWhenVendorIsSybase() throws Exception {
        setUrlSplitting("sybase", "jdbc:sybase:Tds:server123:1234/bd1234");
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);

        boolean result = TomcatAddDataSource.run(handler, this.getTestArguments());

        assertCorrect(result, getDefaultCssQuery() + "[serverName=server123][databaseName=bd1234][portNumber=1234]");
    }

    private void unsetUrlSplitting() {
        idata.getRules().addCondition(asFalse("jdbc.driver.spliturl"));
    }

    private void setUrlSplitting(String vendor, String connectionUrl) {
        idata.getRules().addCondition(asTrue("jdbc.driver.spliturl"));
        idata.getVariables().setProperty("jdbc.driver.vendor.name", vendor);
        idata.getVariables().setProperty("jdbc.datasource.connectionurl", connectionUrl);
    }
}
