package com.redhat.installer.tests.asconfiguration.ascontroller;

import com.redhat.installer.asconfiguration.ascontroller.EmbeddedServerCommands;
import org.jboss.as.security.vault.VaultSession;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@RunWith(PowerMockRunner.class)
@PrepareForTest({EmbeddedServerCommands.class})
public class EmbeddedServerCommandsTest {

    @Test
    public void testMaskPassword() throws Throwable {

        EmbeddedServerCommands embeddedServerCommands = new EmbeddedServerCommands();
        VaultSession vaultMock = Mockito.mock(VaultSession.class);

        PowerMockito.whenNew(VaultSession.class)
                .withArguments(Mockito.anyString(),
                        Mockito.anyString(),
                        Mockito.anyString(),
                        Mockito.anyString(),
                        Mockito.anyInt(),
                        Mockito.anyBoolean()).thenReturn(vaultMock);

        embeddedServerCommands.createVaultSession(Mockito.anyString(),
                Mockito.anyString(),
                Mockito.anyString(),
                Mockito.anyString(),
                Mockito.anyInt(), Mockito.anyString());

        when(vaultMock.addSecuredAttribute("ssl","attribute", "foo".toCharArray())).thenReturn("bar");

        String result  = embeddedServerCommands.maskPassword("ssl", "attribute", "foo");

        assertEquals("${bar}",result);

    }

}
