package com.redhat.installer.framework.testers;

import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.Validator.Status;
import com.redhat.installer.framework.mock.MockProcessingClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.util.Map;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

/**
 * Created by thauser on 2/3/14.
 */
public abstract class ValidatorTester {
    public MockProcessingClient mpc;
    public Validator v;

    @Before
    public void start() {
        mpc = new MockProcessingClient();
    }
    @After
    public void end() {
        mpc = null;
        v = null;
    }

    public void assertOkResult(){
        assertTrue(v.validate(mpc) == Status.OK);
    }

    public void assertWarningResult() { assertTrue(v.validate(mpc) == Status.WARNING); }

    public void assertErrorResult(){
        assertTrue(v.validate(mpc) == Status.ERROR);
    }
}
