package com.redhat.installer.framework.stub;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.rules.Condition;

/**
 * Test utility to stub conditions
 */
public class ConditionStubber {

    /**
     * Set to true the condition defined by the {@code key} parameter.
     * @param key The condition name
     * @return The condition
     */
    public static Condition asTrue(String key) {
        return define(key, true);
    }

    /**
     * Set to false the condition defined by the {@code key} parameter.
     * @param key The condition name
     * @return The condition
     */
    public static Condition asFalse(String key) {
        return define(key, false);
    }

    /**
     * Condition stub implementation
     * @param key The name of the condition
     * @param value The boolean assignation for the condition
     * @return The condition
     */
    private static Condition define(String key, boolean value) {
        return new Condition() {
            {setId(key);}

            @Override
            public void readFromXML(IXMLElement xmlcondition) throws Exception {

            }

            @Override
            public boolean isTrue() {
                return value;
            }

            @Override
            public void makeXMLData(IXMLElement conditionRoot) {

            }
        };
    }

}
