package com.redhat.installer.layering.validator.container;

import org.osgi.framework.Version;

public class HigherVersionValidator implements VersionValidator {
    private final String minVersion;

    public HigherVersionValidator(String minVersion) {
        this.minVersion = minVersion;
    }

    @Override
    public String minSupportedVersion() {
        return minVersion;
    }

    @Override
    public String maxSupportedVersion() {
        return "";
    }

    @Override
    public VersionState validate(Version version) {
        Version minSupportedVersion = new Version(minVersion);
        if (version.compareTo(minSupportedVersion) < 0) {
            return VersionState.LowVersion;
        } else {
            return VersionState.OK;
        }
    }
}
