package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.utils.JarUtils;

import java.io.IOException;
import java.util.jar.JarFile;

/**
 * Created by dsoukhov on 02/09/16.
 */
public class VerifyJsfJars implements DataValidator {
    private String formattedMessage;

    @Override
    public Status validateData(AutomatedInstallData adata) {

        String apiJarTmpPath = adata.getVariable("jsfapi.input.tmp");
        String implJarPathTmpPath = adata.getVariable("jsfimpl.input.tmp");

        String apiJarPath = apiJarTmpPath == null ? adata.getVariable("jsfapi.input"): apiJarTmpPath;
        String implJarPath = implJarPathTmpPath == null ? adata.getVariable("jsfimpl.input"): implJarPathTmpPath;
        String combinedMsg = adata.getVariable("jsf.validator.combined.msg");
        try (JarFile apiJar = JarUtils.getJarFromPath(apiJarPath); JarFile implJar = JarUtils.getJarFromPath(implJarPath)){
            if(!getJarTypeFromPomAndManifest(apiJar, "api")){
                combinedMsg +=String.format(adata.langpack.getString("jsf.error.invalid.api"), apiJarPath)+"\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
            }
            if(!getJarTypeFromPomAndManifest(implJar, "impl")){
                combinedMsg +=String.format(adata.langpack.getString("jsf.error.invalid.impl"), implJarPath)+"\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
            }
        } catch (IOException e) {
            setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.JarError"), apiJarPath));
            return Status.ERROR;
        }
        return Status.OK;
    }

    public boolean getJarTypeFromPomAndManifest(JarFile jar, String type) throws IOException {
        boolean isType;
        isType= JarUtils.checkValueOfResource(jar, JarUtils.POM_PATH, "artifactId",type);

        isType= !isType? JarUtils.checkValueOfResource(jar, JarUtils.MANIFEST_PATH, "Bundle-Description",type):isType;

        return isType;

    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    public void setFormattedMessage(String message) {
        formattedMessage = message;
    }
    @Override
    public String getFormattedMessage() {
        return formattedMessage;
    }
}
