package org.jboss.brmsbpmsuite.patching.client;

import org.junit.Test;

import java.io.File;
import java.io.IOException;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertFalse;

//TODO add bundle tests once supported.
public class DistributionRecognizerTest extends BaseClientPatcherTest {

    @Test
    public void isDistributionExplodedTest() throws IOException {
        File zippedWarDistributionRoot = getCPResourceAsFile("/was8-patcher-test/brms-distro/business-central.war");
        File explodedDistributionRoot = getCPResourceAsFile("/was8-patcher-test/brms-distro/");

        DistributionRecognizer distributionRecognizer = new DistributionRecognizerImpl();
        // True for exploded distro
        assertTrue(distributionRecognizer.isDistributionExploded(explodedDistributionRoot));

        // False for zipped WAR distro
        assertFalse(distributionRecognizer.isDistributionExploded(zippedWarDistributionRoot));
    }
}