package org.jboss.brmsbpmsuite.patching.xml;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class XMLDocumentDao {
    private final DocumentBuilder documentBuilder;
    private final Transformer transformer;

    public XMLDocumentDao() throws ParserConfigurationException, TransformerConfigurationException {
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        transformer = TransformerFactory.newInstance().newTransformer();
    }

    public Document load(InputStream inputStream) throws IOException, SAXException {
        return documentBuilder.parse(inputStream);
    }

    public void save(OutputStream outputStream, Document document) throws TransformerException {
        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
    }

}
