package org.jboss.brmsbpmsuite.patching.systemproperty;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.HashMap;
import java.util.Map;

public class SystemPropertyLoader {
    public static Map<String, Node> load(Document document) {
        Element systemProperties = (Element) document.getElementsByTagName(SystemPropertyNodeName.SYSTEM_PROPERTIES.text).item(0);
        return systemProperties == null ? new HashMap<>() : propertyMapFrom(systemProperties);
    }

    private static Map<String, Node> propertyMapFrom(Element systemProperties) {
        NodeList propertyList = systemProperties.getElementsByTagName(SystemPropertyNodeName.PROPERTY.text);
        Map<String, Node> map = new HashMap<>();
        for (int i = 0; i < propertyList.getLength(); i++) {
            Node property = propertyList.item(i);
            Node name = property.getAttributes().getNamedItem(SystemPropertyNodeName.NAME.text);
            map.put(name.getTextContent(), property);
        }
        return map;
    }
}
