package org.jboss.brmsbpmsuite.patching.phase;

import static com.google.common.base.CaseFormat.LOWER_CAMEL;
import static com.google.common.base.CaseFormat.UPPER_UNDERSCORE;

public enum PatchingPhase {
    CHECK_DISTRO("checking"),
    CHECK_VERSION("checking the version of"),
    BACKUP("backing-up"),
    APPLY("applying the patch to"),
    EXPLODE_WAR("exploding"),
    ZIP_WAR("zipping");

    public final String action;

    PatchingPhase(String action) {
        this.action = action;
    }

    public static PatchingPhase fromString(String phaseName) {
        try {
            return valueOf(LOWER_CAMEL.to(UPPER_UNDERSCORE, phaseName.trim()));
        } catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unrecognized phaseName '" + phaseName + "'!", ex);
        }
    }

}
