/*
 * Copyright (c) 2020. Red Hat, Inc. and/or its affiliates.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.impact.analysis.model.left;

import java.util.ArrayList;
import java.util.List;

import static java.util.stream.Collectors.joining;

public class LeftHandSide {
    private final List<Pattern> patterns = new ArrayList<>();

    public List<Pattern> getPatterns() {
        return patterns;
    }

    public void addPattern(Pattern pattern) {
        patterns.add(pattern);
    }

    @Override
    public String toString() {
        return "LeftHandSide{" +
                "patterns=" + patterns.stream().map( Object::toString ).collect( joining("\n", "\n", "") ) +
                '}';
    }
}
