/*
 * Copyright (c) 2020. Red Hat, Inc. and/or its affiliates.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.impact.analysis.model;

import org.drools.impact.analysis.model.left.LeftHandSide;
import org.drools.impact.analysis.model.right.RightHandSide;

public class Rule {

    private final String pkg;
    private final String name;
    private final String resource;

    private final LeftHandSide lhs = new LeftHandSide();
    private final RightHandSide rhs = new RightHandSide();

    public Rule( String pkg, String name, String resource ) {
        this.pkg = pkg;
        this.name = name;
        this.resource = resource;
    }

    public String getPkg() {
        return pkg;
    }

    public String getResource() {
        return resource;
    }

    public String getName() {
        return name;
    }


    public LeftHandSide getLhs() {
        return lhs;
    }

    public RightHandSide getRhs() {
        return rhs;
    }

    @Override
    public String toString() {
        return "Rule{" +
                "pkg='" + pkg + '\'' +
                ", name='" + name + '\'' +
                ", resource='" + resource + '\'' +
                ",\n lhs=" + lhs +
                ",\n rhs=" + rhs +
                '}';
    }
}
