package com.izforge.izpack.gui.dynamic;

import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.panels.JFocusPanel;

import java.awt.*;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * A JPanel that has two JTextFields on the same line. For KeyValueDynamicComponent, left hand is
 * the key and right hand is the value.
 */
public class TwoJTextFieldJPanel extends JPanel implements KeyValueDynamicComponent
{

    private static final long serialVersionUID = 8369099216227655047L;
    

    private final JTextField keyField;
    private final JTextField valueField;

    public TwoJTextFieldJPanel(String key, String value)
    {
        super(new GridLayout(1, 1), true);

       
        final JTextField keyField = new JTextField();
        JTextField valueField = new JTextField();
        
        if (!key.equals("")) {
            keyField.setText(key);
            keyField.setEditable(false);
            keyField.setFocusable(false);
            valueField.setText(value);
        }

        this.keyField = keyField;
        this.valueField = valueField;

        this.keyField.addFocusListener(new FocusListenerAutoScroll());
        this.valueField.addFocusListener(new FocusListenerAutoScroll());
        this.valueField.addFocusListener(new FocusListenerRepaint());
        this.keyField.addFocusListener(new FocusListenerRepaint());

        super.add(new JFocusPanel(this.keyField));
        super.add(new JFocusPanel(this.valueField));
    }

    public TwoJTextFieldJPanel(String key, String value, boolean editable)
    {
        this(key,value);
        keyField.setEditable(editable);
        keyField.setBackground(Color.WHITE);
    }
    
    public TwoJTextFieldJPanel(){
        this("", "");
    }

    public String getKey()
    {
        return keyField.getText();
    }

    public String getValue()
    {
        return valueField.getText();
    }
    
    public JTextField getKeyField(){
        return keyField;
    }
    
    public JTextField getValueField(){
        return valueField;
    }

}
