/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.AttachedObjectListHolder;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueBindingValueExpressionAdapter;
import javax.faces.component.ValueExpressionValueBindingAdapter;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class UIComponentBase
extends UIComponent {
    private static Logger LOGGER = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    private static final String ADDED = UIComponentBase.class.getName() + ".ADDED";
    private static Map<Class<?>, Map<String, PropertyDescriptor>> descriptors = new WeakHashMap();
    private Map<String, PropertyDescriptor> pdMap = null;
    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> listenersByEventClass;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private AttributesMap attributes = null;
    private String clientId = null;
    private String id = null;
    private UIComponent parent = null;
    private List<UIComponent> children = null;
    private Map<String, UIComponent> facets = null;
    private AttachedObjectListHolder<FacesListener> listeners;
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private boolean transientFlag = false;
    private BehaviorsMap behaviors;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator<UIComponent> EMPTY_ITERATOR = new /* Unavailable Anonymous Inner Class!! */;

    public UIComponentBase() {
        this.populateDescriptorsMapIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDescriptorsMapIfNecessary() {
        Class<?> clazz = this.getClass();
        Map map = descriptors;
        synchronized (map) {
            this.pdMap = (Map)descriptors.get(clazz);
        }
        if (null != this.pdMap) {
            return;
        }
        PropertyDescriptor[] pd = this.getPropertyDescriptors();
        if (pd != null) {
            this.pdMap = new HashMap(pd.length, 1.0f);
            for (PropertyDescriptor aPd : pd) {
                this.pdMap.put(aPd.getName(), aPd);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "fine.component.populating_descriptor_map", new Object[]{clazz, Thread.currentThread().getName()});
            }
            Map reCheckMap = null;
            Map map2 = descriptors;
            synchronized (map2) {
                reCheckMap = (Map)descriptors.get(clazz);
            }
            if (null != reCheckMap) {
                return;
            }
            map2 = descriptors;
            synchronized (map2) {
                descriptors.put(clazz, this.pdMap);
            }
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pd;
        try {
            pd = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new FacesException((Throwable)e);
        }
        return pd;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap((UIComponent)this, null);
        }
        return this.attributes;
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object result = null;
        ValueExpression ve = this.getValueExpression(name);
        if (null != ve) {
            result = ve.getClass().equals(ValueExpressionValueBindingAdapter.class) ? ((ValueExpressionValueBindingAdapter)ve).getWrapped() : new ValueBindingValueExpressionAdapter(ve);
        }
        return result;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (binding != null) {
            ValueExpressionValueBindingAdapter adapter = new ValueExpressionValueBindingAdapter(binding);
            this.setValueExpression(name, (ValueExpression)adapter);
        } else {
            this.setValueExpression(name, null);
        }
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.clientId == null) {
            Renderer renderer;
            UIComponent namingContainerAncestor;
            UIComponent parent = namingContainerAncestor = this.getNamingContainerAncestor();
            String parentId = null;
            if (parent != null) {
                parentId = parent.getContainerClientId(context);
            }
            this.clientId = this.getId();
            if (this.clientId == null) {
                String generatedId = null != namingContainerAncestor && namingContainerAncestor instanceof UniqueIdVendor ? ((UniqueIdVendor)namingContainerAncestor).createUniqueId(context, null) : context.getViewRoot().createUniqueId();
                this.setId(generatedId);
                this.clientId = this.getId();
            }
            if (parentId != null) {
                StringBuilder idBuilder = new StringBuilder(parentId.length() + 1 + this.clientId.length());
                this.clientId = idBuilder.append(parentId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(this.clientId).toString();
            }
            if ((renderer = this.getRenderer(context)) != null) {
                this.clientId = renderer.convertClientId(context, this.clientId);
            }
        }
        return this.clientId;
    }

    public String getId() {
        return this.id;
    }

    private UIComponent getNamingContainerAncestor() {
        for (UIComponent namingContainer = this.getParent(); namingContainer != null; namingContainer = namingContainer.getParent()) {
            if (!(namingContainer instanceof NamingContainer)) continue;
            return namingContainer;
        }
        return null;
    }

    public void setId(String id) {
        if (this.id == null || !this.id.equals(id)) {
            UIComponentBase.validateId((String)id);
            this.id = id;
        }
        this.clientId = null;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    public void setParent(UIComponent parent) {
        if (parent == null) {
            if (this.parent != null) {
                this.doPreRemoveProcessing(FacesContext.getCurrentInstance(), (UIComponent)this);
                this.parent = parent;
            }
            this.compositeParent = null;
        } else {
            this.parent = parent;
            if (this.getAttributes().get(ADDED) == null) {
                this.getAttributes().put(ADDED, Boolean.TRUE);
                this.doPostAddProcessing(FacesContext.getCurrentInstance(), (UIComponent)this);
                this.getAttributes().remove(ADDED);
            }
        }
    }

    public boolean isRendered() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)UIComponent.PropertyKeys.rendered, (Object)Boolean.TRUE).toString());
    }

    public void setRendered(boolean rendered) {
        this.getStateHelper().put((Serializable)UIComponent.PropertyKeys.rendered, (Object)rendered);
    }

    public String getRendererType() {
        return (String)this.getStateHelper().eval((Serializable)UIComponent.PropertyKeys.rendererType);
    }

    public void setRendererType(String rendererType) {
        this.getStateHelper().put((Serializable)UIComponent.PropertyKeys.rendererType, (Object)rendererType);
    }

    public boolean getRendersChildren() {
        Renderer renderer;
        boolean result = false;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            result = renderer.getRendersChildren();
        }
        return result;
    }

    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList((UIComponent)this);
        }
        return this.children;
    }

    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    private static void eraseParent(UIComponent component) {
        List children;
        int index;
        UIComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getChildCount() > 0 && (index = (children = parent.getChildren()).indexOf(component)) >= 0) {
            children.remove(index);
            return;
        }
        if (parent.getFacetCount() > 0) {
            Map facets = parent.getFacets();
            Iterator entries = facets.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getValue() != component) continue;
                entries.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private static void validateId(String id) {
        if (id == null) {
            return;
        }
        int n = id.length();
        if (n < 1) {
            throw new IllegalArgumentException("Empty id attribute is not allowed");
        }
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(id);
        }
    }

    public UIComponent findComponent(String expr) {
        if (expr == null) {
            throw new NullPointerException();
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        char sepChar = UINamingContainer.getSeparatorChar((FacesContext)ctx);
        String SEPARATOR_STRING = String.valueOf(sepChar);
        if (expr.length() == 0) {
            throw new IllegalArgumentException("\"\"");
        }
        UIComponentBase base = this;
        if (expr.charAt(0) == sepChar) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            expr = expr.substring(1);
        } else if (!(base instanceof NamingContainer)) {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        UIComponent result = null;
        String[] segments = expr.split(SEPARATOR_STRING);
        int i = 0;
        int length = segments.length - 1;
        while (i < segments.length) {
            result = UIComponentBase.findComponent((UIComponent)base, (String)segments[i], (i == 0 ? 1 : 0) != 0);
            if (i == 0 && result == null && segments[i].equals(base.getId())) {
                result = base;
            }
            if (result != null && !(result instanceof NamingContainer) && length > 0) {
                throw new IllegalArgumentException(segments[i]);
            }
            if (result == null) break;
            base = result;
            ++i;
            --length;
        }
        return result;
    }

    private static UIComponent findComponent(UIComponent base, String id, boolean checkId) {
        if (checkId && id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator i = base.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = (UIComponent)i.next();
            if (!(kid instanceof NamingContainer)) {
                if (checkId && id.equals(kid.getId())) {
                    result = kid;
                    break;
                }
                result = UIComponentBase.findComponent((UIComponent)kid, (String)id, (boolean)true);
                if (result == null) continue;
                break;
            }
            if (!id.equals(kid.getId())) continue;
            result = kid;
            break;
        }
        return result;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return super.invokeOnComponent(context, clientId, callback);
    }

    public Map<String, UIComponent> getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap((UIComponent)this);
        }
        return this.facets;
    }

    public int getFacetCount() {
        if (this.facets != null) {
            return this.facets.size();
        }
        return 0;
    }

    public UIComponent getFacet(String name) {
        if (this.facets != null) {
            return (UIComponent)this.facets.get(name);
        }
        return null;
    }

    public Iterator<UIComponent> getFacetsAndChildren() {
        Object result;
        int childCount = this.getChildCount();
        int facetCount = this.getFacetCount();
        if (0 == childCount && 0 == facetCount) {
            result = EMPTY_ITERATOR;
        } else if (0 == childCount) {
            Collection unmodifiable = Collections.unmodifiableCollection(this.getFacets().values());
            result = unmodifiable.iterator();
        } else if (0 == facetCount) {
            List unmodifiable = Collections.unmodifiableList(this.getChildren());
            result = unmodifiable.iterator();
        } else {
            result = new FacetsAndChildrenIterator((UIComponent)this);
        }
        return result;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException();
        }
        if (event instanceof BehaviorEvent) {
            BehaviorEvent behaviorEvent = (BehaviorEvent)event;
            Behavior behavior = behaviorEvent.getBehavior();
            behavior.broadcast(behaviorEvent);
        }
        if (this.listeners == null) {
            return;
        }
        for (FacesListener listener : (FacesListener[])this.listeners.asArray(FacesListener.class)) {
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.decode(context, (UIComponent)this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(context, null);
        if (!this.isRendered()) {
            return;
        }
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, (Object)this);
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeBegin(context, (UIComponent)this);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeChildren(context, (UIComponent)this);
            }
        } else if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                child.encodeAll(context);
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Renderer renderer;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.popComponentFromEL(context);
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeEnd(context, (UIComponent)this);
        }
        this.popComponentFromEL(context);
    }

    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new AttachedObjectListHolder();
        }
        this.listeners.add((Object)listener);
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        FacesListener[] listeners = (FacesListener[])this.listeners.asArray(FacesListener.class);
        if (listeners.length == 0) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> results = new ArrayList<FacesListener>(listeners.length);
        for (FacesListener listener : listeners) {
            if (!clazz.isAssignableFrom(listener.getClass())) continue;
            results.add(listener);
        }
        return results.toArray((FacesListener[])Array.newInstance(clazz, results.size()));
    }

    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        if (eventClass == null) {
            throw new NullPointerException();
        }
        if (componentListener == null) {
            throw new NullPointerException();
        }
        if (this.initialStateMarked()) {
            this.initialState = false;
        }
        if (null == this.listenersByEventClass) {
            this.listenersByEventClass = new HashMap(3, 1.0f);
        }
        UIComponent.ComponentSystemEventListenerAdapter facesLifecycleListener = new UIComponent.ComponentSystemEventListenerAdapter(componentListener, (UIComponent)this);
        ArrayList<UIComponent.ComponentSystemEventListenerAdapter> listenersForEventClass = (ArrayList<UIComponent.ComponentSystemEventListenerAdapter>)this.listenersByEventClass.get(eventClass);
        if (listenersForEventClass == null) {
            listenersForEventClass = new ArrayList<UIComponent.ComponentSystemEventListenerAdapter>(3);
            this.listenersByEventClass.put(eventClass, listenersForEventClass);
        }
        if (!listenersForEventClass.contains(facesLifecycleListener)) {
            listenersForEventClass.add(facesLifecycleListener);
        }
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        if (eventClass == null) {
            throw new NullPointerException();
        }
        if (componentListener == null) {
            throw new NullPointerException();
        }
        List listeners = this.getListenersForEventClass(eventClass);
        if (listeners != null && !listeners.isEmpty()) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                SystemEventListener item = (SystemEventListener)i.next();
                UIComponent.ComponentSystemEventListenerAdapter csla = (UIComponent.ComponentSystemEventListenerAdapter)item;
                ComponentSystemEventListener l = csla.getWrapped();
                if (!l.equals(componentListener)) continue;
                i.remove();
                break;
            }
        }
    }

    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> eventClass) {
        if (eventClass == null) {
            throw new NullPointerException();
        }
        List result = null;
        if (this.listenersByEventClass != null) {
            result = (List)this.listenersByEventClass.get(eventClass);
        }
        return result;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processValidators(context);
        }
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processUpdates(context);
        }
        this.popComponentFromEL(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] stateStruct = new Object[2];
        Object[] childState = EMPTY_ARRAY;
        this.pushComponentToEL(context, null);
        try {
            stateStruct[0] = this.saveState(context);
            int count = this.getChildCount() + this.getFacetCount();
            if (count > 0) {
                ArrayList<Object> stateList = new ArrayList<Object>(count);
                if (this.getChildCount() > 0) {
                    for (UIComponent kid : this.getChildren()) {
                        if (kid.isTransient()) continue;
                        stateList.add(kid.processSaveState(context));
                    }
                }
                if (this.getFacetCount() > 0) {
                    for (Map.Entry entry : this.getFacets().entrySet()) {
                        UIComponent facet = (UIComponent)entry.getValue();
                        if (facet.isTransient()) continue;
                        Object facetState = facet.processSaveState(context);
                        Object[] facetSaveState = new Object[]{entry.getKey(), facetState};
                        stateList.add(facetSaveState);
                    }
                }
                childState = stateList.toArray();
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
        stateStruct[1] = childState;
        return stateStruct;
    }

    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] stateStruct = (Object[])state;
        Object[] childState = (Object[])stateStruct[1];
        this.restoreState(context, stateStruct[0]);
        int i = 0;
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                Object currentState;
                if (kid.isTransient() || (currentState = childState[i++]) == null) continue;
                this.pushComponentToEL(context, null);
                kid.processRestoreState(context, currentState);
                this.popComponentFromEL(context);
            }
        }
        if (this.getFacetCount() > 0) {
            int facetsSize = this.getFacets().size();
            for (int j = 0; j < facetsSize; ++j) {
                Object[] facetSaveState;
                if (null == (facetSaveState = (Object[])childState[i++])) continue;
                String facetName = (String)facetSaveState[0];
                Object facetState = facetSaveState[1];
                UIComponent facet = (UIComponent)this.getFacets().get(facetName);
                this.pushComponentToEL(context, null);
                facet.processRestoreState(context, facetState);
                this.popComponentFromEL(context);
            }
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Renderer getRenderer(FacesContext context) {
        String rendererType = this.getRendererType();
        Renderer result = null;
        if (rendererType != null) {
            result = context.getRenderKit().getRenderer(this.getFamily(), rendererType);
            if (null == result && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Can't get Renderer for type " + rendererType);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            String id = this.getId();
            id = null != id ? id : this.getClass().getName();
            LOGGER.fine("No renderer-type for component " + id);
        }
        return result;
    }

    public void markInitialState() {
        super.markInitialState();
        if (this.listeners != null) {
            this.listeners.markInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List listener : this.listenersByEventClass.values()) {
                if (!(listener instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)listener).markInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior behavior : (List)entry.getValue()) {
                    if (!(behavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)behavior).markInitialState();
                }
            }
        }
    }

    public void clearInitialState() {
        super.clearInitialState();
        if (this.listeners != null) {
            this.listeners.clearInitialState();
        }
        if (this.listenersByEventClass != null) {
            for (List listener : this.listenersByEventClass.values()) {
                if (!(listener instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)listener).clearInitialState();
            }
        }
        if (this.behaviors != null) {
            for (Map.Entry entry : this.behaviors.entrySet()) {
                for (ClientBehavior behavior : (List)entry.getValue()) {
                    if (!(behavior instanceof PartialStateHolder)) continue;
                    ((PartialStateHolder)behavior).clearInitialState();
                }
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = null;
        if (context == null) {
            throw new NullPointerException();
        }
        assert (!this.transientFlag);
        if (this.initialStateMarked()) {
            Object savedFacesListeners = this.listeners != null ? this.listeners.saveState(context) : null;
            Object savedSysEventListeners = this.saveSystemEventListeners(context);
            Object savedBehaviors = this.saveBehaviorsState(context);
            Object savedBindings = null;
            if (this.bindings != null) {
                savedBindings = this.saveBindingsState(context);
            }
            Object savedHelper = null;
            if (this.stateHelper != null) {
                savedHelper = this.stateHelper.saveState(context);
            }
            if (savedFacesListeners == null && savedSysEventListeners == null && savedBehaviors == null && savedBindings == null && savedHelper == null) {
                return null;
            }
            if (values == null || values.length != 5) {
                values = new Object[]{savedFacesListeners, savedSysEventListeners, savedBehaviors, savedBindings, savedHelper};
            }
            return values;
        }
        if (values == null || values.length != 6) {
            values = new Object[6];
        }
        values[0] = this.listeners != null ? this.listeners.saveState(context) : null;
        values[1] = this.saveSystemEventListeners(context);
        values[2] = this.saveBehaviorsState(context);
        if (this.bindings != null) {
            values[3] = this.saveBindingsState(context);
        }
        if (this.stateHelper != null) {
            values[4] = this.stateHelper.saveState(context);
        }
        values[5] = this.id;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        if (values[0] != null) {
            if (this.listeners == null) {
                this.listeners = new AttachedObjectListHolder();
            }
            this.listeners.restoreState(context, values[0]);
        }
        if (values[1] != null) {
            Map m = this.restoreSystemEventListeners(context, values[1]);
            if (this.listenersByEventClass != null) {
                this.listenersByEventClass.putAll(m);
            } else {
                this.listenersByEventClass = m;
            }
        }
        if (values[2] != null) {
            this.behaviors = this.restoreBehaviorsState(context, values[2]);
        }
        if (values[3] != null) {
            this.bindings = UIComponentBase.restoreBindingsState((FacesContext)context, (Object)values[3]);
        }
        if (values[4] != null) {
            this.getStateHelper().restoreState(context, values[4]);
        }
        if (values.length == 6 && values[5] != null) {
            this.id = (String)values[5];
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        StateHolderSaver result;
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == attachedObject) {
            return null;
        }
        Class<?> mapOrCollectionClass = attachedObject.getClass();
        boolean newWillSucceed = true;
        try {
            int modifiers = mapOrCollectionClass.getModifiers();
            newWillSucceed = Modifier.isPublic(modifiers);
            if (newWillSucceed) {
                newWillSucceed = null != mapOrCollectionClass.getConstructor(new Class[0]);
            }
        }
        catch (Exception e) {
            newWillSucceed = false;
        }
        if (newWillSucceed && attachedObject instanceof Collection) {
            Collection attachedCollection = (Collection)attachedObject;
            ArrayList<StateHolderSaver> resultList = null;
            for (Object item : attachedCollection) {
                if (item == null || item instanceof StateHolder && ((StateHolder)item).isTransient()) continue;
                if (resultList == null) {
                    resultList = new ArrayList<StateHolderSaver>(attachedCollection.size() + 1);
                    resultList.add(new StateHolderSaver(context, mapOrCollectionClass));
                }
                resultList.add(new StateHolderSaver(context, item));
            }
            result = resultList;
        } else if (newWillSucceed && attachedObject instanceof Map) {
            Map attachedMap = (Map)attachedObject;
            ArrayList<StateHolderSaver> resultList = null;
            for (Map.Entry entry : attachedMap.entrySet()) {
                Object value;
                Object key = entry.getKey();
                if (key instanceof StateHolder && ((StateHolder)key).isTransient() || (value = entry.getValue()) instanceof StateHolder && ((StateHolder)value).isTransient()) continue;
                if (resultList == null) {
                    resultList = new ArrayList<StateHolderSaver>(attachedMap.size() * 2 + 1);
                    resultList.add(new StateHolderSaver(context, mapOrCollectionClass));
                }
                resultList.add(new StateHolderSaver(context, key));
                resultList.add(new StateHolderSaver(context, value));
            }
            result = resultList;
        } else {
            result = new StateHolderSaver(context, attachedObject);
        }
        return result;
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        Object result;
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == stateObj) {
            return null;
        }
        if (stateObj instanceof List) {
            List stateList = (List)stateObj;
            StateHolderSaver collectionSaver = (StateHolderSaver)stateList.get(0);
            Class mapOrCollection = (Class)collectionSaver.restore(context);
            if (Collection.class.isAssignableFrom(mapOrCollection)) {
                Collection retCollection = null;
                try {
                    retCollection = (Collection)mapOrCollection.newInstance();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
                int len = stateList.size();
                for (int i = 1; i < len; ++i) {
                    try {
                        retCollection.add(((StateHolderSaver)stateList.get(i)).restore(context));
                        continue;
                    }
                    catch (ClassCastException cce) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, cce.toString(), cce);
                        }
                        throw new IllegalStateException("Unknown object type");
                    }
                }
                result = retCollection;
            } else {
                Map retMap = null;
                try {
                    retMap = (Map)mapOrCollection.newInstance();
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    throw new IllegalStateException("Unknown object type");
                }
                int len = stateList.size();
                for (int i = 1; i < len; i += 2) {
                    try {
                        retMap.put(((StateHolderSaver)stateList.get(i)).restore(context), ((StateHolderSaver)stateList.get(i + 1)).restore(context));
                        continue;
                    }
                    catch (ClassCastException cce) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, cce.toString(), cce);
                        }
                        throw new IllegalStateException("Unknown object type");
                    }
                }
                result = retMap;
            }
        } else if (stateObj instanceof StateHolderSaver) {
            StateHolderSaver saver = (StateHolderSaver)stateObj;
            result = saver.restore(context);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return result;
    }

    private static Map<String, ValueExpression> restoreBindingsState(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, ValueExpression> bindings = new HashMap<String, ValueExpression>(names.length);
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)states[i]));
        }
        return bindings;
    }

    private Object saveBindingsState(FacesContext context) {
        if (this.bindings == null) {
            return null;
        }
        Object[] values = new Object[2];
        values[0] = this.bindings.keySet().toArray(new String[this.bindings.size()]);
        Object[] bindingValues = this.bindings.values().toArray();
        for (int i = 0; i < bindingValues.length; ++i) {
            bindingValues[i] = UIComponentBase.saveAttachedState((FacesContext)context, (Object)bindingValues[i]);
        }
        values[1] = bindingValues;
        return values;
    }

    private Object saveSystemEventListeners(FacesContext ctx) {
        if (this.listenersByEventClass == null) {
            return null;
        }
        int size = this.listenersByEventClass.size();
        Object[][] listeners = new Object[size][2];
        int idx = 0;
        boolean savedState = false;
        for (Map.Entry e : this.listenersByEventClass.entrySet()) {
            Object[] target = listeners[idx++];
            target[0] = e.getKey();
            target[1] = UIComponentBase.saveAttachedState((FacesContext)ctx, e.getValue());
            if (target[1] == null) {
                target[0] = null;
                continue;
            }
            savedState = true;
        }
        return savedState ? listeners : (Object[][])null;
    }

    private Map<Class<? extends SystemEvent>, List<SystemEventListener>> restoreSystemEventListeners(FacesContext ctx, Object state) {
        if (state == null) {
            return null;
        }
        Object[][] listeners = (Object[][])state;
        HashMap<Class<? extends SystemEvent>, List<SystemEventListener>> m = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(listeners.length, 1.0f);
        for (Object[] source : listeners) {
            m.put((Class)source[0], (List)UIComponentBase.restoreAttachedState((FacesContext)ctx, (Object)source[1]));
        }
        return m;
    }

    Map<String, PropertyDescriptor> getDescriptorMap() {
        return this.pdMap;
    }

    private void doPostAddProcessing(FacesContext context, UIComponent added) {
        if (this.parent.isInView()) {
            UIComponentBase.publishAfterViewEvents((FacesContext)context, (Application)context.getApplication(), (UIComponent)added);
        }
    }

    private void doPreRemoveProcessing(FacesContext context, UIComponent toRemove) {
        if (this.parent.isInView()) {
            UIComponentBase.disconnectFromView((FacesContext)context, (Application)context.getApplication(), (UIComponent)toRemove);
        }
    }

    public void addClientBehavior(String eventName, ClientBehavior behavior) {
        this.assertClientBehaviorHolder();
        Collection eventNames = this.getEventNames();
        if (eventNames == null) {
            throw new IllegalStateException("Attempting to add a Behavior to a component that does not support any event types. getEventTypes() must return a non-null Set.");
        }
        if (eventNames.contains(eventName)) {
            ArrayList<ClientBehavior> eventBehaviours;
            if (this.initialStateMarked() && this.behaviors != null) {
                for (Map.Entry entry : this.behaviors.entrySet()) {
                    for (ClientBehavior b : (List)entry.getValue()) {
                        if (!(b instanceof PartialStateHolder)) continue;
                        ((PartialStateHolder)behavior).clearInitialState();
                    }
                }
            }
            if (null == this.behaviors) {
                HashMap modifiableMap = new HashMap(5, 1.0f);
                this.behaviors = new BehaviorsMap(modifiableMap, null);
            }
            if (null == (eventBehaviours = (ArrayList<ClientBehavior>)this.behaviors.get((Object)eventName))) {
                eventBehaviours = new ArrayList<ClientBehavior>(3);
                BehaviorsMap.access$200((BehaviorsMap)this.behaviors).put(eventName, eventBehaviours);
            }
            eventBehaviours.add(behavior);
        }
    }

    public Collection<String> getEventNames() {
        this.assertClientBehaviorHolder();
        return null;
    }

    public Map<String, List<ClientBehavior>> getClientBehaviors() {
        if (null == this.behaviors) {
            return Collections.emptyMap();
        }
        return this.behaviors;
    }

    public String getDefaultEventName() {
        this.assertClientBehaviorHolder();
        return null;
    }

    private void assertClientBehaviorHolder() {
        if (!this.isClientBehaviorHolder()) {
            throw new IllegalStateException("Attempting to use a Behavior feature with a component that does not support any event types. Component must implement BehaviourHolder interface.");
        }
    }

    private boolean isClientBehaviorHolder() {
        return ClientBehaviorHolder.class.isInstance(this);
    }

    private Object saveBehaviorsState(FacesContext context) {
        Object[] state = null;
        if (null != this.behaviors && this.behaviors.size() > 0) {
            boolean stateWritten = false;
            Object[] attachedBehaviors = new Object[this.behaviors.size()];
            int i = 0;
            for (List eventBehaviors : this.behaviors.values()) {
                Object[] attachedEventBehaviors = new Object[eventBehaviors.size()];
                for (int j = 0; j < attachedEventBehaviors.length; ++j) {
                    Object object = attachedEventBehaviors[j] = this.initialStateMarked() ? this.saveBehavior(context, (ClientBehavior)eventBehaviors.get(j)) : UIComponentBase.saveAttachedState((FacesContext)context, eventBehaviors.get(j));
                    if (stateWritten) continue;
                    stateWritten = attachedEventBehaviors[j] != null;
                }
                attachedBehaviors[i++] = attachedEventBehaviors;
            }
            if (stateWritten) {
                state = new Object[]{this.behaviors.keySet().toArray(new String[this.behaviors.size()]), attachedBehaviors};
            }
        }
        return state;
    }

    private BehaviorsMap restoreBehaviorsState(FacesContext context, Object state) {
        if (null != state) {
            Object[] values = (Object[])state;
            String[] names = (String[])values[0];
            Object[] attachedBehaviors = (Object[])values[1];
            if (!this.initialStateMarked()) {
                HashMap modifiableMap = new HashMap(names.length, 1.0f);
                for (int i = 0; i < attachedBehaviors.length; ++i) {
                    Object[] attachedEventBehaviors = (Object[])attachedBehaviors[i];
                    ArrayList<ClientBehavior> eventBehaviors = new ArrayList<ClientBehavior>(attachedBehaviors.length);
                    for (int j = 0; j < attachedEventBehaviors.length; ++j) {
                        eventBehaviors.add((ClientBehavior)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)attachedEventBehaviors[j]));
                    }
                    modifiableMap.put(names[i], eventBehaviors);
                }
                return new BehaviorsMap(modifiableMap, null);
            }
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                List existingBehaviors = (List)this.behaviors.get((Object)names[i]);
                this.restoreBehaviors(context, existingBehaviors, (Object[])attachedBehaviors[i]);
            }
            return this.behaviors;
        }
        return null;
    }

    private Object saveBehavior(FacesContext ctx, ClientBehavior behavior) {
        return behavior instanceof StateHolder ? ((StateHolder)behavior).saveState(ctx) : null;
    }

    private void restoreBehaviors(FacesContext ctx, List<ClientBehavior> existingBehaviors, Object[] state) {
        int len = state.length;
        for (int i = 0; i < len; ++i) {
            ClientBehavior behavior = existingBehaviors.get(i);
            if (state[i] == null || !(behavior instanceof StateHolder)) continue;
            if (state[i] instanceof StateHolderSaver) {
                ((StateHolderSaver)state[i]).restore(ctx);
                continue;
            }
            ((StateHolder)behavior).restoreState(ctx, state[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishAfterViewEvents(FacesContext context, Application application, UIComponent component) {
        component.setInView(true);
        try {
            ArrayList<Object> clist;
            component.pushComponentToEL(context, component);
            application.publishEvent(context, PostAddToViewEvent.class, (Object)component);
            if (component.getChildCount() > 0) {
                clist = new ArrayList(component.getChildren());
                for (UIComponent uIComponent : clist) {
                    UIComponentBase.publishAfterViewEvents((FacesContext)context, (Application)application, (UIComponent)uIComponent);
                }
            }
            if (component.getFacetCount() > 0) {
                clist = new ArrayList(component.getFacets().values());
                for (UIComponent uIComponent : clist) {
                    UIComponentBase.publishAfterViewEvents((FacesContext)context, (Application)application, (UIComponent)uIComponent);
                }
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    private static void disconnectFromView(FacesContext context, Application application, UIComponent component) {
        application.publishEvent(context, PreRemoveFromViewEvent.class, (Object)component);
        component.setInView(false);
        component.compositeParent = null;
        if (component.getChildCount() > 0) {
            List children = component.getChildren();
            for (UIComponent c : children) {
                UIComponentBase.disconnectFromView((FacesContext)context, (Application)application, (UIComponent)c);
            }
        }
        if (component.getFacetCount() > 0) {
            Map facets = component.getFacets();
            for (UIComponent c : facets.values()) {
                UIComponentBase.disconnectFromView((FacesContext)context, (Application)application, (UIComponent)c);
            }
        }
    }

    static /* synthetic */ Object[] access$300() {
        return EMPTY_OBJECT_ARRAY;
    }

    static /* synthetic */ void access$400(UIComponent x0) {
        UIComponentBase.eraseParent((UIComponent)x0);
    }

    static /* synthetic */ Iterator access$500() {
        return EMPTY_ITERATOR;
    }
}

