/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.borders.MetouiaDots;

public class MetouiaToolBarBorder
extends AbstractBorder
implements UIResource,
SwingConstants {
    protected MetouiaDots dots = new MetouiaDots(5, 5);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        boolean isHorizontal = ((JToolBar)c).getOrientation() == 0;
        g.setColor(MetalLookAndFeel.getControlHighlight());
        if (isHorizontal) {
            g.drawLine(0, 0, w - 1, 0);
        } else {
            g.drawLine(0, 0, 0, h - 1);
        }
        g.setColor(MetalLookAndFeel.getControlShadow());
        if (isHorizontal) {
            g.drawLine(0, h - 1, w - 1, h - 1);
        } else {
            g.drawLine(w - 1, 0, w - 1, h - 1);
        }
        g.translate(x, y);
        if (((JToolBar)c).isFloatable()) {
            if (((JToolBar)c).getOrientation() == 0) {
                this.dots.setDotsArea(5, c.getSize().height - 4);
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.dots.paintIcon(c, g, 2, 2);
                } else {
                    this.dots.paintIcon(c, g, c.getBounds().width - 12, 2);
                }
            } else {
                this.dots.setDotsArea(c.getSize().width - 4, 5);
                this.dots.paintIcon(c, g, 2, 2);
            }
        }
        g.translate(-x, -y);
    }

    public Insets getBorderInsets(Component c) {
        Insets insets = new Insets(3, 3, 3, 3);
        if (((JToolBar)c).isFloatable()) {
            if (((JToolBar)c).getOrientation() == 0) {
                insets.left = 8;
            } else {
                insets.top = 8;
            }
        }
        return insets;
    }
}

