/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.title.BaseHeaderPainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public abstract class ImageWrapperHeaderPainter
extends BaseHeaderPainter {
    protected Image singleTile = null;
    protected SubstanceTitlePainter baseTitlePainter;
    protected ImageWrapperHeaderPainter secondaryTitlePainter;
    protected LinkedHashMap<String, Image> colorizedTileMap = new LinkedHashMap<String, Image>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Image> eldest) {
            return this.size() > 10;
        }
    };
    protected float textureAlpha = 0.3f;
    protected boolean isPaintingSeparators = false;

    public ImageWrapperHeaderPainter() {
        this(true, true);
    }

    public ImageWrapperHeaderPainter(boolean isPaintingToolbars, boolean isPaintingGeneralDecorationAreas) {
        super(isPaintingToolbars, isPaintingGeneralDecorationAreas);
    }

    public void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, float borderAlpha) {
        SubstanceTheme tileTheme = theme;
        if (this.baseTitlePainter == null) {
            tileTheme = theme.getActiveTitlePaneTheme();
            graphics.setColor(tileTheme.getColorScheme().getMidColor());
            graphics.fillRect(0, 0, width, height);
        } else {
            this.baseTitlePainter.paintTitleBackground(graphics, comp, width, height, leftTitleX, rightTitleX, theme, borderAlpha);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileTheme, 0, 0, 0, 0, width, height);
        if (this.isPaintingSeparators) {
            temp.translate(0, height - 1);
            SubstanceCoreUtilities.paintSeparator(comp, temp, theme.getActiveTitlePaneTheme().getColorScheme(), SubstanceCoreUtilities.isThemeDark(theme.getActiveTitlePaneTheme()), width, 1, 0, false, 0);
            temp.dispose();
        }
    }

    public void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceTheme theme, boolean hasDarkBorder) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        int dx = 0;
        int dy = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
                dy += comp.getLocationOnScreen().y - titlePane.getLocationOnScreen().y;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                for (c = titlePane; c != rootPane; c = c.getParent()) {
                    dx -= c.getX();
                    dy -= c.getY();
                }
            }
        }
        SubstanceTheme tileTheme = theme;
        if (this.baseTitlePainter instanceof ArcHeaderPainter) {
            ArcHeaderPainter baseArc = (ArcHeaderPainter)this.baseTitlePainter;
            baseArc.paintExtraBackground(graphics, parent, comp, width, height, theme, hasDarkBorder);
        } else {
            tileTheme = theme.getActiveTitlePaneTheme();
            graphics.setColor(tileTheme.getColorScheme().getMidColor());
            graphics.fillRect(0, 0, width, height);
        }
        Graphics2D temp = (Graphics2D)graphics.create();
        this.tileArea(temp, comp, tileTheme, dx, dy, 0, 0, width, height);
        if (this.isPaintingSeparators && SwingUtilities.getAncestorOfClass(JToolBar.class, comp) == null) {
            int pWidth = titlePane == null ? parent.getWidth() : titlePane.getWidth();
            temp.translate(-dx, height - 1);
            SubstanceCoreUtilities.paintSeparator(comp, temp, theme.getActiveTitlePaneTheme().getColorScheme(), SubstanceCoreUtilities.isThemeDark(theme.getActiveTitlePaneTheme()), pWidth, 1, 0, false, 0);
        }
        temp.dispose();
    }

    protected void tileArea(Graphics2D g, Component comp, SubstanceTheme tileTheme, int offsetTextureX, int offsetTextureY, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite(comp, this.textureAlpha, g));
        Image colorizedTile = this.getColorizedTile(tileTheme);
        int tileWidth = colorizedTile.getWidth(null);
        int tileHeight = colorizedTile.getHeight(null);
        offsetTextureX %= tileWidth;
        int currTileTop = -(offsetTextureY %= tileHeight);
        do {
            int currTileLeft = -offsetTextureX;
            do {
                graphics.drawImage(colorizedTile, currTileLeft, currTileTop, null);
            } while ((currTileLeft += tileWidth) < width);
        } while ((currTileTop += tileHeight) < height);
        graphics.dispose();
    }

    public SubstanceTitlePainter getSecondaryPainter() {
        if (this.baseTitlePainter instanceof ArcHeaderPainter) {
            return ((ArcHeaderPainter)this.baseTitlePainter).getSecondaryPainter();
        }
        return this;
    }

    public void setBaseTitlePainter(SubstanceTitlePainter baseTitlePainter) {
        this.baseTitlePainter = baseTitlePainter;
    }

    public void setTextureAlpha(float textureAlpha) {
        this.textureAlpha = textureAlpha;
    }

    public void setPaintingSeparators(boolean isPaintingSeparators) {
        this.isPaintingSeparators = isPaintingSeparators;
    }

    protected synchronized Image getColorizedTile(SubstanceTheme theme) {
        Image result = this.colorizedTileMap.get(theme.getDisplayName());
        if (result == null) {
            BufferedImage tileBi = new BufferedImage(this.singleTile.getWidth(null), this.singleTile.getHeight(null), 2);
            tileBi.getGraphics().drawImage(this.singleTile, 0, 0, null);
            result = SubstanceImageCreator.getThemeImage(tileBi, theme, false);
            this.colorizedTileMap.put(theme.getDisplayName(), result);
        }
        return result;
    }
}

