/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewResource;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.AbstractFaceletCache;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.impl.DefaultFacelet;
import org.apache.myfaces.view.facelets.impl.DefaultResourceResolver;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

public final class DefaultFaceletFactory
extends FaceletFactory {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    protected final Logger log = Logger.getLogger(DefaultFaceletFactory.class.getName());
    private URL _baseUrl;
    private Compiler _compiler;
    private Map<String, DefaultFacelet> _compositeComponentMetadataFacelets;
    private long _refreshPeriod;
    private Map<String, URL> _relativeLocations;
    private ResourceResolver _resolver;
    private DefaultResourceResolver _defaultResolver;
    private FaceletCache<Facelet> _faceletCache;
    private AbstractFaceletCache<Facelet> _abstractFaceletCache;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        ParameterCheck.notNull("compiler", compiler);
        ParameterCheck.notNull("resolver", resolver);
        this._compiler = compiler;
        this._compositeComponentMetadataFacelets = new HashMap<String, DefaultFacelet>();
        this._relativeLocations = new HashMap<String, URL>();
        this._resolver = resolver;
        if (this._resolver instanceof DefaultResourceResolver) {
            this._defaultResolver = (DefaultResourceResolver)this._resolver;
        }
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        FaceletCacheFactory cacheFactory = (FaceletCacheFactory)FactoryFinder.getFactory((String)"javax.faces.view.facelets.FaceletCacheFactory");
        this._faceletCache = cacheFactory.getFaceletCache();
        FaceletCache.MemberFactory<Facelet> faceletFactory = new FaceletCache.MemberFactory<Facelet>(){

            public Facelet newInstance(URL url) throws IOException {
                return DefaultFaceletFactory.this._createFacelet(url);
            }
        };
        FaceletCache.MemberFactory<Facelet> viewMetadataFaceletFactory = new FaceletCache.MemberFactory<Facelet>(){

            public Facelet newInstance(URL url) throws IOException {
                return DefaultFaceletFactory.this._createViewMetadataFacelet(url);
            }
        };
        if (this._faceletCache instanceof AbstractFaceletCache) {
            this._abstractFaceletCache = (AbstractFaceletCache)this._faceletCache;
            FaceletCache.MemberFactory<Facelet> compositeComponentMetadataFaceletFactory = new FaceletCache.MemberFactory<Facelet>(){

                public Facelet newInstance(URL url) throws IOException {
                    return DefaultFaceletFactory.this._createCompositeComponentMetadataFacelet(url);
                }
            };
            try {
                Method setMemberFactoriesMethod = AbstractFaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
                setMemberFactoriesMethod.setAccessible(true);
                setMemberFactoriesMethod.invoke(this._faceletCache, faceletFactory, viewMetadataFaceletFactory, compositeComponentMetadataFaceletFactory);
            }
            catch (Exception e) {
                throw new FacesException("Cannot call setMemberFactories method, Initialization of FaceletCache failed.", (Throwable)e);
            }
        }
        try {
            Method setMemberFactoriesMethod = FaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
            setMemberFactoriesMethod.setAccessible(true);
            setMemberFactoriesMethod.invoke(this._faceletCache, faceletFactory, viewMetadataFaceletFactory);
        }
        catch (Exception e) {
            throw new FacesException("Cannot call setMemberFactories method, Initialization of FaceletCache failed.", (Throwable)e);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Using ResourceResolver: " + this._resolver);
            this.log.fine("Using Refresh Period: " + this._refreshPeriod);
        }
    }

    public Compiler getCompiler() {
        return this._compiler;
    }

    private URL getBaseUrl() {
        if (this._baseUrl == null) {
            this._baseUrl = this._resolver.resolveUrl("/");
        }
        return this._baseUrl;
    }

    @Override
    public Facelet getFacelet(FacesContext facesContext, String uri) throws IOException, FaceletException, FacesException, ELException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(facesContext, this.getBaseUrl(), uri);
            if (url != null) {
                ViewResource viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED");
                if (viewResource == null) {
                    HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                    newLoc.put(uri, url);
                    this._relativeLocations = newLoc;
                }
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    @Override
    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        return (Facelet)this._faceletCache.getFacelet(url);
    }

    @Override
    public Facelet getFacelet(FaceletContext ctx, URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this._abstractFaceletCache != null) {
            return this._abstractFaceletCache.getFacelet(ctx, url);
        }
        return (Facelet)this._faceletCache.getFacelet(url);
    }

    public long getRefreshPeriod() {
        return this._refreshPeriod;
    }

    public URL resolveURL(FacesContext context, URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            context.getAttributes().put("oam.facelets.LAST_RESOURCE_RESOLVED", null);
            URL url = this.resolveURL(context, path);
            if (url == null) {
                throw new FileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                URLConnection conn = facelet.getSource().openConnection();
                long lastModified = ResourceLoaderUtils.getResourceLastModified(conn);
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
            }
        }
        return false;
    }

    private DefaultFacelet _createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating Facelet for: " + url);
        }
        String alias = "/" + this._removeFirst(url.getFile(), this.getBaseUrl().getFile());
        try {
            FaceletHandler h = this._compiler.compile(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, h);
            return f;
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet _createViewMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating Facelet used to create View Metadata for: " + url);
        }
        String faceletId = "/" + this._removeFirst(url.getFile(), this.getBaseUrl().getFile());
        String alias = "/viewMetadata" + faceletId;
        try {
            FaceletHandler h = this._compiler.compileViewMetadata(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this._compiler.createExpressionFactory(), url, alias, faceletId, h);
            return f;
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet _createCompositeComponentMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating Facelet used to create Composite Component Metadata for: " + url);
        }
        String alias = "/compositeComponentMetadata/" + this._removeFirst(url.getFile(), this.getBaseUrl().getFile());
        try {
            FaceletHandler h = this._compiler.compileCompositeComponentMetadata(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, h, true);
            return f;
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    @Override
    public Facelet getViewMetadataFacelet(FacesContext facesContext, String uri) throws IOException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(facesContext, this.getBaseUrl(), uri);
            ViewResource viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED");
            if (url != null) {
                if (viewResource == null) {
                    HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                    newLoc.put(uri, url);
                    this._relativeLocations = newLoc;
                }
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getViewMetadataFacelet(url);
    }

    @Override
    public Facelet getViewMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this._abstractFaceletCache != null) {
            return (Facelet)this._abstractFaceletCache.getViewMetadataFacelet(url);
        }
        return (Facelet)this._faceletCache.getViewMetadataFacelet(url);
    }

    @Override
    public Facelet getCompositeComponentMetadataFacelet(FacesContext facesContext, String uri) throws IOException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(facesContext, this.getBaseUrl(), uri);
            ViewResource viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED");
            if (url != null) {
                if (viewResource == null) {
                    HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                    newLoc.put(uri, url);
                    this._relativeLocations = newLoc;
                }
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getCompositeComponentMetadataFacelet(url);
    }

    @Override
    public Facelet getCompositeComponentMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this._abstractFaceletCache != null) {
            return this._abstractFaceletCache.getCompositeComponentMetadataFacelet(url);
        }
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._compositeComponentMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this._createCompositeComponentMetadataFacelet(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._compositeComponentMetadataFacelets);
                newLoc.put(key, f);
                this._compositeComponentMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    private URL resolveURL(FacesContext context, String path) {
        if (this._defaultResolver != null) {
            return this._defaultResolver.resolveUrl(context, path);
        }
        return this._resolver.resolveUrl(path);
    }

    @Override
    public Facelet compileComponentFacelet(String taglibURI, String tagName, Map<String, Object> attributes) {
        FaceletHandler handler = this._compiler.compileComponent(taglibURI, tagName, attributes);
        String alias = "/component/oamf:" + tagName;
        return new DefaultFacelet(this, this._compiler.createExpressionFactory(), this.getBaseUrl(), alias, alias, handler);
    }

    private String _removeFirst(String string, String toRemove) {
        return Pattern.compile(toRemove, 16).matcher(string).replaceFirst("");
    }
}

