/*
 * Copyright (c) 2011-2020 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */
package io.vertx.json.schema.common;

import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;

public interface SyncValidator extends Validator {

  /**
   * Validate the provided value
   *
   * @param context
   * @param in
   * @throws ValidationException       if the object is not valid
   * @throws NoSyncValidationException if no sync validation can be provided
   */
  void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException;

}
