package io.vertx.ext.web.validation.builder;

import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.json.schema.SchemaParser;

/**
 * This interface is used to build parameter processors supported on every {@link ParameterLocation}.
 * You can use in query and cookie more complex parameters with {@link StyledParameterProcessorFactory}. <br/>
 *
 * Look at {@link Parameters} for all available factories
 */
@FunctionalInterface
public interface ParameterProcessorFactory {

  ParameterProcessor create(ParameterLocation location, SchemaParser jsonSchemaParser);

}
