/*
 * Copyright 2019 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.ext.web.handler.graphql;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;

/**
 * A message recevied over Apollo's {@code subscriptions-transport-ws} transport.
 *
 * @author Rogelio Orts
 */
@VertxGen
public interface ApolloWSMessage {

  /**
   * @return the websocket that received the message
   */
  ServerWebSocket serverWebSocket();

  /**
   * @return the message type
   */
  ApolloWSMessageType type();

  /**
   * @return the message content
   */
  JsonObject content();

}
