/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.IntChecklist;
import com.mchange.util.IntEnumeration;
import com.mchange.util.impl.IntEnumerationHelperBase;
import com.mchange.util.impl.LLICIRecord;
import java.util.NoSuchElementException;

public class LinkedListIntChecklistImpl
implements IntChecklist {
    private final LLICIRecord headRecord = new LLICIRecord();
    private int num_checked = 0;

    public void check(int num) {
        LLICIRecord finger = this.findPrevious(num);
        if (finger.next == null || finger.next.contained != num) {
            LLICIRecord newRec = new LLICIRecord();
            newRec.next = finger.next;
            newRec.contained = num;
            finger.next = newRec;
            ++this.num_checked;
        }
    }

    public void uncheck(int num) {
        LLICIRecord finger = this.findPrevious(num);
        if (finger.next != null && finger.next.contained == num) {
            finger.next = finger.next.next;
            --this.num_checked;
        }
    }

    public boolean isChecked(int num) {
        LLICIRecord finger = this.findPrevious(num);
        return finger.next != null && finger.next.contained == num;
    }

    public void clear() {
        this.headRecord.next = null;
        this.num_checked = 0;
    }

    public int countChecked() {
        return this.num_checked;
    }

    public int[] getChecked() {
        LLICIRecord finger = this.headRecord;
        int[] out = new int[this.num_checked];
        int i = 0;
        while (finger.next != null) {
            out[i++] = finger.next.contained;
            finger = finger.next;
        }
        return out;
    }

    public IntEnumeration checked() {
        return new IntEnumerationHelperBase(){
            LLICIRecord finger;
            {
                this.finger = LinkedListIntChecklistImpl.this.headRecord;
            }

            public int nextInt() {
                try {
                    this.finger = this.finger.next;
                    return this.finger.contained;
                }
                catch (NullPointerException e) {
                    throw new NoSuchElementException();
                }
            }

            public boolean hasMoreInts() {
                return this.finger.next != null;
            }
        };
    }

    private LLICIRecord findPrevious(int num) {
        LLICIRecord finger = this.headRecord;
        while (finger.next != null && finger.next.contained < num) {
            finger = finger.next;
        }
        return finger;
    }
}

