/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.coalesce;

import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;

public class CoalesceTest {
    static final int NUM_ITERS = 10000;
    static final Coalescer c = CoalescerFactory.createCoalescer(null, true, true);

    public static void main(String[] argv) {
        CoalesceTest.doTest();
        System.gc();
        System.err.println("num coalesced after gc: " + c.countCoalesced());
    }

    private static void doTest() {
        String[] strings = new String[10000];
        for (int i = 0; i < 10000; ++i) {
            strings[i] = new String("Hello");
        }
        long start_time = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            String random = strings[i];
            Object object = c.coalesce(random);
        }
        long time_ms = System.currentTimeMillis() - start_time;
        System.out.println("avg time: " + (float)time_ms / 10000.0f + "ms (" + 10000 + " iterations)");
        System.err.println("num coalesced: " + c.countCoalesced());
    }
}

