/*
 * Copyright 2016, gRPC Authors All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.grpc;

/**
 * Do not use this. This is an internal accessor class.
 */
@Internal
public final class InternalLogId extends LogId {
  private InternalLogId(String tag, long id) {
    super(tag, id);
  }

  /**
   * An accessor method for {@link LogId#allocate(String)}.
   *
   * @param tag a loggable tag associated with this tag. The ID that is allocated is guaranteed
   *            to be unique and increasing, irrespective of the tag.
   */
  public static InternalLogId allocate(String tag) {
    return new InternalLogId(tag, LogId.getNextId());
  }
}
