/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.ByteUtils;

public class ShortUtils {
    public static final int UNSIGNED_MAX_VALUE = 65535;

    public static short shortFromByteArray(byte[] bytes, int offset) {
        int out = 0;
        out |= ByteUtils.toUnsigned(bytes[offset + 0]) << 8;
        return (short)(out |= ByteUtils.toUnsigned(bytes[offset + 1]) << 0);
    }

    public static byte[] byteArrayFromShort(short s) {
        byte[] out = new byte[2];
        ShortUtils.shortIntoByteArray(s, 0, out);
        return out;
    }

    public static void shortIntoByteArray(short s, int offset, byte[] bytes) {
        bytes[offset + 0] = (byte)(s >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(s >>> 0 & 0xFF);
    }

    public static int toUnsigned(short s) {
        return s < 0 ? 65536 + s : s;
    }

    private ShortUtils() {
    }
}

