/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.jca.core.classloader;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;


public class Handler extends URLStreamHandler {
    public URLConnection openConnection(URL someUrl) {
        return new HandlerUrlConnection(someUrl);
    }

    class HandlerUrlConnection extends URLConnection {
        HandlerUrlConnection(URL someUrl) {
            super(someUrl);
        }

        public void connect() {
        }

        public InputStream getInputStream() throws java.io.IOException {
            byte bytes[] = PlugInClassLoaderHelper.getResourceAsBytes(url.getPath());

            if (bytes != null) {
                return new java.io.ByteArrayInputStream(bytes);
            } else {
                throw new java.io.IOException(url.getPath() + " not found");
            }
        }
    }
}
