/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.guvnor.common.services.project.model;

import org.junit.Test;
import org.uberfire.backend.vfs.Path;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

public class ModuleTest {

    @Test
    public void nameIsSet() throws Exception {
        final POM pom = new POM(new GAV("groupId",
                                        "artifactId",
                                        "version"));
        pom.setName("my project");
        final Module module = new Module(mock(Path.class),
                                         mock(Path.class),
                                         pom);

        assertEquals("my project",
                     module.getModuleName());
    }

    @Test
    public void nameNotSetUseArtifactId() throws Exception {
        final POM pom = new POM(new GAV("groupId",
                                        "artifactId",
                                        "version"));
        final Module module = new Module(mock(Path.class),
                                         mock(Path.class),
                                         pom);

        assertEquals("artifactId",
                     module.getModuleName());
    }

    @Test
    public void nameNotSetGAVNotSet() throws Exception {
        final POM pom = new POM();
        final Path rootPath = mock(Path.class);
        doReturn("myProject").when(rootPath).getFileName();

        final Module module = new Module(rootPath,
                                         mock(Path.class),
                                         pom);

        assertEquals("myProject",
                     module.getModuleName());
    }
}