package com.redhat.installer.asconfiguration.jsf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by dsoukhov on 23/09/16.
 */
public class JsfUtils {

    /**
     * Returns the cleaned version if it is valid
     * Otherwise, return the empty string
     * @param ver
     * @return
     */

    public static String cleanedVer(String ver){

       //versions of the form a.b, a.b.c, a.b* , a.b.c*
       //where * is the decorator
       Pattern pattern = Pattern.compile("(?<version>^\\s*(2)\\.(1|2)(\\.(\\d){1,2})?)(?<decorator>.*)");
       Matcher matcher = pattern.matcher(ver);
       Matcher m = matcher.find() ? matcher : null ;

       if(m != null){
           String dec = m.group("decorator").trim();
           String cleanedVer = m.group("version").trim();
           //reject if decorator starts with a digit or ends with a delimiter
           // or if version is too short to fit form a.b
           if(cleanedVer.length() > 2 && (dec.length() == 0 || dec.matches("^\\D.*\\w$"))){
               return cleanedVer;
           }
       }
       return "";
   }


}
