package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;

import javax.swing.*;
import java.util.List;

/**
 * A field that can contain remote URLs or Files on the filesystem.
 * Created by thauser on 5/5/15.
 */
public class FileUrlInputField extends DirUrlInputField{

    boolean hidingEnabled;

    public FileUrlInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, String fileExt, String fileExtDesc, boolean mustExist, boolean hidingEnabled) {
        super(parent, data, directory, set, size, validatorConfig, fileExt, fileExtDesc, mustExist);
        this.hidingEnabled = hidingEnabled;
    }

    @Override
    protected void prepareFileChooser(JFileChooser chooser){
        super.prepareFileChooser(chooser);
        chooser.setFileHidingEnabled(this.hidingEnabled);
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
    }
}
