package com.izforge.izpack.panels;

import com.izforge.izpack.util.FileDownloader;
import com.izforge.izpack.gui.patternfly.PatternflyProgressBarUI;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;

import javax.swing.*;
import java.awt.*;
import java.util.concurrent.CountDownLatch;

/**
 * Created by daniel on 4/11/17.
 */
public class FileDownloadManager extends IzPanel {
    private JProgressBar progressBar;
    private FileDownloader fd;
    private boolean result = false;
    private JPanel downloadDialogPanel;
    private String outputPath, url;
    private String associatedVariable;

    public FileDownloadManager(String associatedVariable, String url, InstallData data, InstallerFrame parent) {
        super(parent, data);
        this.associatedVariable = associatedVariable;
        this.url = url;
        fd = new FileDownloader(new DownloadHandler(), url);
        buildUI();
    }

    /**
     * Sets this FileDownloadManager to wait for the CountDownLatch passed as 'start' parameter in the constructor.
     * Once this CountDownLatch hits 0, the file associated with this FileDownloadManager will immediately start.
     *
     */
    public void startDownload() {
        fd.start();
    }

    public void stopDownload() { fd.stopDownload(); }

    private void buildUI() {
        downloadDialogPanel = new JPanel();
        downloadDialogPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = GridBagConstraints.FIRST_LINE_START;
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.weighty = 1.0;

        outputPath = fd.getPath();

        JTextMessagePane statusMsg = new JTextMessagePane(String.format(idata.langpack.getString("filedownloader.downloading"), url),
                maxMessageWidth, fontMetrics);
        downloadDialogPanel.add(statusMsg, c);

        c.gridy = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        progressBar = new JProgressBar();
        progressBar.setStringPainted(false);
        progressBar.setUI(new PatternflyProgressBarUI());
        progressBar.setFocusable(false);

        downloadDialogPanel.add(progressBar, c);
    }

    public void hideDownloadDialog() {
        if (downloadDialogPanel != null) {
            Window ancestor = SwingUtilities.getWindowAncestor(downloadDialogPanel);
            if (ancestor != null){
                ancestor.setVisible(false);
            }
        }
    }

    public boolean getResult() {
        return result;
    }

    public String getFilePath() {
        return outputPath;
    }

    public FileDownloader getFileDownloaderThread(){
        return fd;
    }

    public String getAssociatedVariable() { return associatedVariable; }

    public JPanel getDownloadDisplayPanel() { return downloadDialogPanel; }

    private class DownloadHandler implements com.izforge.izpack.util.AbstractUIProgressHandler {

        @Override
        public void emitNotification(String message) {
        }

        @Override
        public boolean emitWarning(String title, String message) {
            return true;
        }

        @Override
        public void emitError(String title, String message) {
            hideDownloadDialog();
            FileDownloadManager.this.emitError(title, message);
        }

        @Override
        public void emitErrorAndBlockNext(String title, String message) {
        }

        public int askQuestion(String title, String question, int choices) {
            return 0;
        }

        @Override
        public int askQuestion(String title, String question, int choices, int default_choice) {
            return 0;
        }

        @Override
        public void startAction(String name, final int max) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    progressBar.setVisible(true);
                    progressBar.setMinimum(0);
                    progressBar.setMaximum(max);
                    parent.lockNextButton();
                }
            });
        }

        @Override
        public void stopAction() {
        }

        @Override
        public void nextStep(String step_name, int step_no, int no_of_substeps) {

        }

        @Override
        public void setSubStepNo(int no_of_substeps) {

        }

        @Override
        public void progress(final int pos, final String message) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    progressBar.setValue(pos);
                }
            });
        }
    }
}
