# Red Hat Business Automation Installers

This repository contains izpack descriptors and dependencies for the RHPAM and RHDM installers.

## Red Hat Decision Manager Installer
decision-central.war and kie-server.war are installed and configured into an existing EAP installation in a way consistent with existing installation documentation.

## Red Hat Process Automation Manager Installer
business-central.war and kie-server.war are installed and configured into an existing EAP installation in a way consistent with existing installation documentation.

## Build Instructions

1. Clone the following repositories:
   - https://github.com/jboss-integration/izpack
   - https://github.com/jboss-integration/installer-commons
   - https://github.com/jboss-integration/rhba-installers
 
2. Configure your maven settings to add the correct internal repo.

3. Build the projects in this order:
   - izpack
   - installer-commons
   - rhba-installers

4. Execute the installer jar for RHPAM or RHDM indistinctly
   ```
   $ java -jar rhpam/target/rhpam-installer-{VERSION}.jar
   ```  
## Debugging the installer
Run the jar as the following to attach a debugger to the port specified by `address`.
```bash
$ java -jar -DTRACE=true -Xdebug -Xrunjdwp:server=y,transport=dt_socket,address=5009,suspend=y rhpam/target/rhpam-installer-{VERSION}.jar
```
