package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import org.apache.commons.lang.SystemUtils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.stream.Stream;

/**
 * Created by eunderhi on 22/10/15.
 */
public class JarInPathValidator extends BinaryInPathValidator {
    @Override
    protected String getWarningId() {
        return "cluster.demo.no.jar";
    }

    @Override
    protected String getBinaryName() {
        return SystemUtils.IS_OS_WINDOWS ? "jar.exe" : "jar";
    }

    @Override
    protected Status getFailureStatus() {
        return Status.ERROR;
    }
}
