package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.util.AbstractUIProcessHandler;
import org.jboss.dmr.ModelNode;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Tom on 11/26/2015.
 */
public class SetStandaloneServerProperties extends PostInstallation {
    public boolean setStandaloneServerProps(){
        List<ModelNode> commandResults = addStandaloneProperties(arguments);
        return installResult(commandResults);
    }

    private static List<ModelNode> addStandaloneProperties(String[]args){
        List<ModelNode> results = new ArrayList<ModelNode>();
        for (int i = 0; i < args.length; i++){
            String[] propSplit = args[i].split("=");
            String property = propSplit[0];
            String value = propSplit[1].replace('\\', '/');
            results.addAll(serverCommands.addServerCommandSystemProperty(property, value));
        }
        return results;
    }

    @Override
    protected Class getClassName() {
        return SetStandaloneServerProperties.class;
    }

    @Override
    protected boolean performOperation() {
        return setStandaloneServerProps();
    }

}
