package org.jboss.brmsbpmsuite.patching.integrationtests.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.zip.ZipUtil;

/**
 * Util class for manipulation with zip and zip compatible archives.
 */
public final class ZipUtils {

    /**
     * Unpacks all archives of a selected archive type that are located in selected root directory.
     * @param rootDirectory Directory from which all archives are unpacked.
     * @param archiveType Archive type of unpacked archives.
     * @return True, if there were some archives unpacked.
     * @throws IOException
     */
    public static boolean unpackAll(final File rootDirectory, final String archiveType) throws IOException {
        final Collection<File> packedFiles = FileUtil.findFiles(rootDirectory, "*." + archiveType, null);
        for (File packedFile : packedFiles) {
            // /oook/eeek/something.war -> /oook/eeek/something
            final String unpackedDirName =
                    packedFile.getPath().substring(0, packedFile.getPath().lastIndexOf("." + archiveType))
                            + Constants.UNPACKED_DIR_SUFFIX;
            ZipUtil.unpack(packedFile, new File(unpackedDirName));
            FileUtil.deleteFile(packedFile);
            FileUtil.renameFile(new File(unpackedDirName), packedFile);
        }
        return !packedFiles.isEmpty();
    }

    /**
     * Packs all unpacked directories with selected directory name suffix into archives of selected type
     * and deletes original directories.
     * @param rootDirectory Directory from which all matching directories are packed into archives.
     * @param archiveType Archive type of resulting archives.
     * @throws IOException
     */
    public static void packAll(final File rootDirectory, final String archiveType) throws IOException {
        final Collection<File> unpackedArchives = FileUtil.findDirectories(rootDirectory, "*." + archiveType, true);
        for (File unpackedDir : unpackedArchives) {
            final String archiveName = unpackedDir.getPath() + ".tmp";
            ZipUtil.pack(unpackedDir, new File(archiveName), false);
            FileUtils.deleteDirectory(unpackedDir);
            FileUtil.renameFile(new File(archiveName), unpackedDir);
        }
    }

    private ZipUtils() {
        // It is prohibited to instantiate util classes.
    }
}
