Business Automation Updating Tools
=======================================
This repository contains few different modules used to create, bundle and apply (at client side) the updates for
Business Automation.

See [Patching Summary](https://mojo.redhat.com/docs/DOC-1021353) for more info about requirements, naming conventions,
and overall summary of updating.

Modules
-------
 * `client-patcher`: Contains client-side updating tool. Written in pure Java, so users only need Java installation to apply the updates.
 * `distribution-diffs`: Responsible for generating diffs between specified versions of all the supported distributions
 (EAP, JWS, Generic, etc)
 * `patch-distributions`: Bundles the the client update tool together with the distribution diffs. These distributions are the final.
 result that will be distributed to users/customers. Different distributions are created for RHPAM and RHDM.
 * `integration-tests`: Contains black-box integration (system) tests.

The entire update creation process consists of the following steps:

 1. Compile, test, and package the client updater (module `client-patcher`). It is later bundled into the the final
 update zips.
 2. Generate the diffs between two specified versions, the minor version (e.g. 6.1.0) and the latest update version (e.g. 6.1.3).
 3. Create the final -update.zip files. These include the generated diffs and the `client-patcher` which is able to apply
 those diffs on top of user installations.

Profiles
--------
* `rhpam`: Use this profile to build Red Hat Process Automation Manager update distribution. 
* `rhdm`: Use this profile to build Red Hat Decision Manager update distribution.
* `non-first-patch`: There are two kinds of Business Automation updates: the first one in the stream and the others (second, third, ...).
The difference is that the first update does not depend on any metadata from previous updates (there are none). So the build process is a bit
different. To generate first update no profile is required. This way no dependency on previous updates is defined. To generate second, third, etc update `non-first-patch` profile (example `mvn clean install -Prhpam,rhdm,non-first-patch`..
The subsequent updates need artifacts (metadata) built as part of the previous update release, so these artifact need to be available either in local repository
or in some remote one.
* `integration-tests`: Use this profile to run black-box integration tests. You can use this profile together with rhdm, rhpam, or both profiles. You can specify whether to test from latest update (`patch-from-patch` profile) or from latest release (`patch-from-ga` profile, default).
You can also test individual distribution artifacts, such as `kie-server-ee8`, `controller-jws`, `business-central-eap7-deployable`.

Creating the update (diffs)
--------------------------
The diffs are created as a part of the `distribution-diffs` module execution. Maven is used to download and unzip the
distribution files. After that, a simple Bash script is called that will create all the diffs and some additional metadata.
These diffs are then packaged into .zip files and exposed as Maven build artifacts.

The diff itself includes any file that changed (read as different checksum) between the two specified .zip files
(the deliverables are .zip files with .war files inside). For example, as part of the RHDM 7.0.0 release there is a file called `rhdm-7.0.0.GA-redhat-3-kie-server-ee8.zip`. As part of the RHDM 7.0.1 release there is a file called
`rhdm-7.0.1.GA-redhat-2-kie-server-ee8.zip`. The script takes two directories (with the unzipped content),
compares them, and creates a directory with the new content (updated or added files) and some metadata files. As a result, there are "dumb" diffs of basically anything with different checksum, as any .jar file that has been rebuilt will
be included. An advantage of these "dumb" diffs is that we do not need to update any possible references to .jar names. The distribution looks exactly the same after applying the diff as it was originally built. A disadvantage is that the update .zip files are slightly larger.


Applying the update
------------------
The update or set of updates is distributed as a .zip file with .sh and .bat scripts inside the .zip file that automatically apply the updates to current installations.

The script takes two mandatory parameters: `<path-to-distribution-root>` and `<distribution-type>`.
For example `./apply-updates.sh /opt/tomcat/webapps/kie-server.war kie-server-jws` applies the updates to the specified .war file. Please note that only updates for Business Automation are part of the update. Updates to EAP or JWS need to be applied using the EAP or JWS updating mechanism.

For more information about how to apply the updates to specific distribution types, run `apply-updates.[sh|bat] -h` in your command terminal.

As a part of a Business Automation update release, the following deliverables are created:

* `rhdm-<version>-update.zip`
* `rhpam-<version>-update.zip`

Note that there is one additional .zip file for Maven repository updates: `rhpam/rhdm-<version>-incremental-maven-repository.zip`. This update, however, is created together with the Maven repository .zip distribution itself and is _not_ created using the update tooling in this source repository.


Handling cumulativity and content from one-off updates
------------------------------------------
The generated `-update.zip` files are cumulative. That means that the latest update can be applied to any update version before that down to the base minor version. For example, the `-6.1.3-update.zip` can be applied on top of 6.1.0, 6.1.1, and 6.1.2. To accomplish this, the client-patcher tool needs some information about all the previous updates, specifically a list of the files that were updated or added. This way the tool makes sure all these previously added files are removed before applying the changes (the `-update.zip` file
contains only the updated or new files that should be applied on top of the specified minor version, so the distributions need to be cleaned up into some known state). This greatly decreases the size of the updates because multiple diffs are not required (example, diff between 6.1.0 and 6.1.1 and diff between 6.1.1 and 6.1.2). a disadvantage is that the updates can not be rolled back easily.

When applying the updates, the `client-patcher` needs to remove any files possibly added by one-off updates. These include .jar files in most cases and bigger parts of the .war files in case of fixes for GWT-based UI. Unfortunately, the distributions do not contain any metadata about whic one-off updates were applied. The tool just follows a few simple rules to remove anything that was potentially added by the one-off updates.

Additional features
-------------------
 * **Backup** - Before applying any updates, the client script will backup the specified distribution. It simply copies the
   distribution file/directory into the `backup/<current-timestamp>` sub-directory. The top-level `backup` directory is created
   at the same file system level as the `apply-updates` script.

 * **Blacklist** - The `blacklist.txt` file enables users to preserve any files, usually configuration files, from being updated by this update tool. When a file is listed in the `blacklist.txt` file, the update script does not replace the file with the new version but instead leaves the file in place and in the same location adds the new version with a `.new` suffix. If users blacklist files that are no longer being distributed, the update tool creates an empty marker file with a `.removed` suffix. Users can then choose to retain, merge, or delete these new files manually.
