package com.redhat.installer.logging;

import com.izforge.izpack.installer.AutomatedInstallData;
import org.jboss.logmanager.formatters.PatternFormatter;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallationLogger {

    private static Logger logger;
    private static String loggingPath;

    public static Logger getLogger() {
        String currentLoggingPath = createLogggingPath();
        if (!currentLoggingPath.equals(loggingPath)) {
            loggingPath = currentLoggingPath;
            logger = createLogger();
        }
        return logger;
    }

    private static Logger createLogger() {
        createLoggingDirectoryIfNeeded(loggingPath);
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        Handler h = null;
        try {
            h = new FileHandler(loggingPath, true);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        h.setFormatter(new PatternFormatter("%m%n"));
        h.setLevel(Level.INFO);
        logger.addHandler(h);
        logger.setLevel(Level.INFO);
        return logger;
    }

    private static String createLogggingPath() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String logFileConfig = idata.getVariable("installation.logfile");
        if (logFileConfig == null) {
            throw new IllegalArgumentException("A required configuration variable is missing: 'installation.logfile'");
        }
        return idata.getInstallPath() + File.separator + logFileConfig;
    }

    private static void createLoggingDirectoryIfNeeded(String logFileConfig) {
        File logFile = new File(logFileConfig);
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
    }

}
