/*
 * IzPack - Copyright 2001-2008 Julien Ponge, All Rights Reserved.
 * 
 * http://izpack.org/
 * http://izpack.codehaus.org/
 * 
 * Copyright 2003 Tino Schwarze
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/**
 * A validator to check whether the given number is an integer >= 0
 * <p/>
 *
 * @author Jyoti Tripathi
 */
public class OffsetPosIntValidator implements Validator {

    public Status validate(ProcessingClient client) {
        Status failureStatus = Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;

        int numfields = client.getNumFields();
        int offset;
        for (int i = 0; i < numfields; i++) {
            String value = client.getFieldContents(i);

            if ((value == null) || (value.length() == 0)) {
                return failureStatus;
            }

            try {
                offset = Integer.parseInt(value);
            } catch (Exception e) {
                return failureStatus;
            }

            if (offset < 0)
                return failureStatus;
        }

        return Status.OK;
    }

}
